/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.lineup;

import fork.lib.base.collection.Pair;
import fork.lib.bio.seq.parser.bedgraph.BedGraphReader;
import fork.lib.bio.seq.parser.bedgraph.BedGraphSplitter;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeScoring;
import fork.lib.bio.seq.region.landscape.LandscapeScoringResultEntry;
import fork.lib.bio.seq.region.lineup.Lineup;
import fork.lib.bio.seq.region.lineup.LineupSide;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import java.io.File;
import java.util.ArrayList;

public class LineupPercent
extends Lineup {
    public LineupPercent(GenomicRegionsBuilder gb, String bedgraph, int left, int right, int m) throws Exception {
        BedGraphSplitter sp = new BedGraphSplitter(bedgraph);
        sp.start();
        for (String chr : gb.chromosomeList()) {
            File lbf = sp.getFileForChromosome(chr);
            if (lbf == null) continue;
            LineupPercent.scoreGBLB(this.vecs, gb.getGenomicRegionsBuilderForChromosome(chr), new BedGraphReader(lbf).getLandscapeBuilder(), left, right, m);
        }
        sp.removeAll();
    }

    protected static Vector stretch(Vector vs, int len) {
        Vector ret = new Vector();
        for (int i = 0; i < len; ++i) {
            int l = (int)Math.floor((double)(vs.size() - 1) * (double)i / (double)len);
            int h = (int)Math.floor((double)(vs.size() - 1) * (double)(i + 1) / (double)len);
            double v = vs.subset(l, h).sum() / (double)(h - l + 1);
            ret.add(v);
        }
        return ret;
    }

    protected static void scoreGBLB(ArrayList<Pair<String, Vector>> vecs, GenomicRegionsBuilder gb, LandscapeBuffer lb, int left, int right, int m) throws Exception {
        GenomicRegionsBuilder cdss = new GenomicRegionsBuilder();
        for (GenomicRegion gr : gb) {
            DirectionalGenomicRegion dr = (DirectionalGenomicRegion)gr;
            try {
                DirectionalGenomicRegion cd = dr.getExtendedRegion(-left, -right);
                cdss.add(cd);
            }
            catch (Exception cd) {}
        }
        LandscapeScoring ls = LineupSide.landscapeScoring(cdss, lb, 10);
        ArrayList<LandscapeScoringResultEntry> res = ls.getResultEntries();
        for (LandscapeScoringResultEntry en : res) {
            if (en.scores.length == 1) continue;
            Vector vec = new Vector(en.scores);
            if (((DirectionalGenomicRegion)en.gr).strand() == '-') {
                vec = vec.invert();
            }
            vec = LineupPercent.stretch(vec, m);
            vecs.add(new Pair<String, Vector>(en.gr.getID() + "\t" + en.gr.toUCSCFormat(), vec));
        }
    }
}

