/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.lineup;

import fork.lib.base.collection.Pair;
import fork.lib.bio.seq.parser.bedgraph.BedGraphReader;
import fork.lib.bio.seq.parser.bedgraph.BedGraphSplitter;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeScoring;
import fork.lib.bio.seq.region.landscape.LandscapeScoringResultEntry;
import fork.lib.bio.seq.region.lineup.Lineup;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.File;
import java.util.ArrayList;

public class LineupSide
extends Lineup {
    private int win;

    public LineupSide() {
    }

    public LineupSide(GenomicRegionsBuilder gb, LandscapeBuffer lb, int win) throws Exception {
        this.win = win;
        LineupSide.scoreGBLB(this.vecs, gb, lb, win);
    }

    public LineupSide(GenomicRegionsBuilder gb, String bedgraph, int win) throws Exception {
        BedGraphSplitter sp = new BedGraphSplitter(bedgraph);
        sp.start();
        for (String chr : gb.getChromosomeList()) {
            File lbf = sp.getFileForChromosome(chr);
            if (lbf == null) continue;
            LineupSide.scoreGBLB(this.vecs, gb.getGenomicRegionsBuilderForChromosome(chr), new BedGraphReader(lbf).getLandscapeBuilder(), win);
        }
        sp.removeAll();
    }

    protected static void scoreGBLB(ArrayList<Pair<String, Vector>> vecs, GenomicRegionsBuilder gb, LandscapeBuffer lb, int win) throws Exception {
        LandscapeScoring ls = LineupSide.landscapeScoring(gb, lb, win);
        ArrayList<LandscapeScoringResultEntry> res = ls.getResultEntries();
        for (LandscapeScoringResultEntry en : res) {
            if (en.scores.length == 1) continue;
            Vector vec = new Vector(en.scores);
            if (((DirectionalGenomicRegion)en.gr).strand() == '-') {
                vec = vec.invert();
            }
            vecs.add(new Pair<String, Vector>(en.gr.getID() + "\t" + en.gr.toUCSCFormat(), vec));
        }
    }

    protected static LandscapeScoring landscapeScoring(GenomicRegionsBuilder gb, LandscapeBuffer lb, final int win) throws Exception {
        return new LandscapeScoring(lb, gb){

            @Override
            protected double[] score(ArrayList<Region> bufs, GenomicRegion gr) throws Exception {
                double[] vs = new double[(int)gr.getRange()];
                int ind = 0;
                for (int i = (int)gr.low(); i <= (int)gr.high(); ++i) {
                    int ir = i - (int)gr.low();
                    if (ind >= bufs.size()) {
                        vs[ir] = 0.0;
                        continue;
                    }
                    while (bufs.get(ind).lowerThan(i) && ++ind < bufs.size()) {
                    }
                    vs[ir] = ind >= bufs.size() ? 0.0 : (bufs.get(ind).contains(i) ? (Double)bufs.get(ind).attr() : 0.0);
                }
                double[] ret = new double[(int)Math.ceil((double)vs.length / (double)win)];
                int rind = 0;
                int count = 0;
                double sum = 0.0;
                double[] dArray = vs;
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double v = dArray[i];
                    if (++count == win) {
                        ret[rind] = sum / (double)count;
                        sum = 0.0;
                        count = 0;
                        ++rind;
                    }
                    sum += v.doubleValue();
                }
                if (rind < ret.length - 1) {
                    ret[ret.length - 1] = sum / (double)count;
                }
                return ret;
            }
        };
    }
}

