/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.locate;

import fork.lib.bio.seq.parser.gtfgff.GtfReader;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.Gene;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.locate.GeneLocatorParam;
import fork.lib.bio.seq.region.locate.RelativeLocation;
import fork.lib.bio.seq.region.locate.RelativeLocationGenic;
import fork.lib.bio.seq.region.locate.RelativeLocationIntergenic;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.File;
import java.util.ArrayList;

public class GeneLocator {
    private GenomicRegionsBuilder gbref;
    private GeneLocatorParam par;

    public GeneLocator(GenomicRegionsBuilder gbref, GeneLocatorParam par) {
        this.gbref = gbref;
        this.par = par;
        if (this.par == null) {
            this.par = new GeneLocatorParam();
        }
    }

    public GeneLocator(GenomicRegionsBuilder gbref) {
        this(gbref, null);
    }

    public ArrayList<RelativeLocation> locate(GenomicRegion gr) throws Exception {
        ArrayList<RelativeLocation> ret = new ArrayList<RelativeLocation>();
        if (gr == null) {
            return ret;
        }
        if (!this.gbref.containsChromosome(gr.chr())) {
            return null;
        }
        ArrayList<Region> refs = this.gbref.getRegionsForChromosome(gr.chr());
        for (int i = 0; i < refs.size(); ++i) {
            Gene gene = (Gene)refs.get(i);
            DirectionalGenomicRegion ref = ((Gene)refs.get(i)).getExtendedRegion(RelativeLocationGenic.PROMOTER_LEN, RelativeLocationGenic.PROMOTER_LEN);
            if (i == 0 && ref.higherThan(gr)) {
                ret.add(new RelativeLocationIntergenic(gr, null, gene));
                continue;
            }
            if (ref.overlapsWith(gr)) {
                ret.add(new RelativeLocationGenic(gr, gene));
                continue;
            }
            if (ref.higherThan(gr)) {
                ret.add(new RelativeLocationIntergenic(gr, (Gene)refs.get(i - 1), gene));
                break;
            }
            if (i != refs.size() - 1 || !ref.lowerThan(gr)) continue;
            ret.add(new RelativeLocationIntergenic(gr, gene, null));
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("C:\\muxingu\\genome\\human\\grch38\\ass");
        File f = new File(dir + "/Homo_sapiens.GRCh38.93_pc.gtfmin");
        GenomicRegionsBuilder gb = new GtfReader(f).genomicRegionsBuilder();
        GeneLocator gl = new GeneLocator(gb);
        GenomicRegion tar = new GenomicRegion("1", 829937, 830000);
        System.out.println(gl.locate(tar));
    }
}

