/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.locate;

import fork.lib.bio.seq.region.Gene;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.Transcript;
import fork.lib.bio.seq.region.locate.RelativeLocation;

public class RelativeLocationGenic
extends RelativeLocation {
    public static int PROMOTER_LEN = 2000;
    protected Gene gene;
    protected String type = "";

    public RelativeLocationGenic(GenomicRegion tar, Gene gene) throws Exception {
        super(tar);
        this.gene = gene;
        this.init();
    }

    protected void init() throws Exception {
        for (Transcript tr : this.gene.children()) {
            if (!this.tar.overlapsWith(tr.promoter(PROMOTER_LEN))) continue;
            this.type = "Promoter";
            return;
        }
        this.type = this.gene.exonContains(this.tar) ? "Exon" : "Intron";
    }

    public String type() {
        return this.type;
    }

    public Gene gene() {
        return this.gene;
    }
}

