/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.peak;

import fork.lib.base.file.io.txt.ReadTable;
import fork.lib.base.format.collection.FormatOp1D;
import fork.lib.bio.seq.parser.bedgraph.BedGraphReader;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeScoring;
import fork.lib.bio.seq.region.peak.PeakIdentifierParam;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.applied.stat.Distribution;
import java.io.File;
import java.util.ArrayList;

public class PeakIdentifier {
    protected LandscapeBuffer lb;
    protected PeakIdentifierParam par;

    public PeakIdentifier(LandscapeBuffer lb) throws Exception {
        this(lb, null);
    }

    public PeakIdentifier(LandscapeBuffer lb, PeakIdentifierParam par) throws Exception {
        this.lb = lb;
        this.par = par;
        this.init();
    }

    protected void init() throws Exception {
        if (this.par == null) {
            this.par = new PeakIdentifierParam();
        }
    }

    public PeakIdentifierParam param() {
        return this.par;
    }

    public GenomicRegionsBuilder getPeaks() throws Exception {
        GenomicRegionsBuilder gb = new GenomicRegionsBuilder();
        String[] chrs = this.lb.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            ArrayList<Region> rs = this.lb.getLandscape2DForChromosome(chr).getRegions();
            this.addPeaks(gb, chr, rs);
        }
        return gb;
    }

    protected void addPeaks(GenomicRegionsBuilder gb, String chr, ArrayList<Region> rs) throws Exception {
        Region peak = null;
        double maxHeight = 0.0;
        for (int j = 0; j < rs.size(); ++j) {
            Region r = rs.get(j);
            if (peak == null) {
                peak = r;
                maxHeight = (Double)r.attr();
                continue;
            }
            if (peak.distanceFrom(r) < (double)this.par.joinGap) {
                peak = new Region(peak.low(), r.high());
                maxHeight = Math.max(maxHeight, (Double)r.attr());
                continue;
            }
            if (maxHeight > (double)this.par.minHeight) {
                gb.add(new GenomicRegion(chr, peak));
            }
            peak = r;
            maxHeight = (Double)r.attr();
        }
        if (peak != null) {
            gb.add(new GenomicRegion(chr, peak));
        }
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("G:/mystudy/phd/files");
        File f = new File(dir + "/data\\human_magnus\\rna2\\fc1\\mcf7_rna2_nt_time-0_r1_fc1\\tophat/mcf7_rna2_nt_time-0_r1_fc1_rev.wig");
        File out = new File(dir + "/peaks.bed");
        LandscapeBuilder lb = new BedGraphReader(f).getLandscapeBuilder();
        PeakIdentifier pi = new PeakIdentifier(lb, null);
        GenomicRegionsBuilder gb = pi.getPeaks();
        LandscapeScoring ls = new LandscapeScoring(lb, gb){};
        ls.writeToBedFile(out);
        Distribution dis = new Distribution(FormatOp1D.objToDouble(new ReadTable(out).getColumn(4)));
        ArrayList<Distribution> qs = dis.quantileSubsets(100);
        for (int i = 0; i < qs.size(); ++i) {
            Distribution q = qs.get(i);
            System.out.println(i + "  " + q.mean() + "   " + q.size());
        }
        double r = qs.get(qs.size() - 1).mean() / qs.get(0).mean();
        System.out.println(r);
    }
}

