/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.peak;

import fork.lib.base.file.FileName;
import fork.lib.bio.seq.parser.bedgraph.BedGraphReader;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.bio.seq.region.peak.PeakIdentifierIslandParam;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import fork.lib.math.applied.learning.peak.HeightPeakDetector;
import java.io.File;
import java.util.ArrayList;

public class PeakIdentifierIsland {
    protected LandscapeBuffer lb;
    protected PeakIdentifierIslandParam par;

    public PeakIdentifierIsland(LandscapeBuffer lb, PeakIdentifierIslandParam par) throws Exception {
        this.lb = lb;
        this.par = par;
        this.init();
    }

    protected void init() throws Exception {
        if (this.par == null) {
            this.par = new PeakIdentifierIslandParam();
        }
    }

    public PeakIdentifierIslandParam param() {
        return this.par;
    }

    public GenomicRegionsBuilder getPeaks() throws Exception {
        GenomicRegionsBuilder gb = new GenomicRegionsBuilder();
        String[] chrs = this.lb.getChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            System.out.println(chr);
            Landscape2D ls = this.lb.getLandscape2DForChromosome(chr);
            HeightPeakDetector dd = new HeightPeakDetector(ls, null);
            ArrayList<Region> ps = dd.getAllPeaks();
            for (int j = 0; j < ps.size(); ++j) {
                gb.add(new GenomicRegion(chr, ps.get(j)));
            }
        }
        gb.sortAll();
        return gb;
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("E:\\muxingu\\mystudy\\phd\\files");
        File f = new File(dir + "/data/chip-seq/norm/norm_wig_chip_htz1-anti660_772-wt_sd_20131104-r1_pe1_sacCer1.wig");
        File od = new File(dir + "/data/chip-seq/norm/peak3");
        LandscapeBuilder lb = new BedGraphReader(f).getLandscapeBuilder();
        PeakIdentifierIsland pi = new PeakIdentifierIsland(lb, null);
        pi.getPeaks().writeToFileBed(new File(od + "/peak_" + FileName.baseName(f) + ".bed"));
    }
}

