/*
 * Decompiled with CFR 0.152.
 */
package prog.core;

import fork.lib.base.file.FileName;
import fork.lib.base.file.FileOp;
import fork.lib.math.applied.stat.FrequencyCount;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import prog.Sys;
import prog.core.Param;
import prog.core.ProgramMain;
import prog.core.aln.res.oncofilt.PathogenicityFilter;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;

public class ProgramCmd
extends ProgramMain {
    public static String FLAG_INDEX = "-i";
    public static String FLAG_ONCO = "-f";
    public static String FLAG_TAG = "-n";

    public ProgramCmd(Writer wr, String dir, String[] infs, String outdir, String tag, Index index, PathogenicityFilter pathofilter, Param par) {
        this.wr = wr;
        this.infs = infs;
        this.index = index;
        this.par = par;
        if (this.par == null) {
            this.par = new Param();
        }
        this.pathofilter = pathofilter;
        ProgramCmd.mkdirs(outdir);
        this.outalndir = outdir + "/align_" + ProgramCmd.rand();
        ProgramCmd.mkdirs(this.outalndir);
        this.outcordir = outdir;
        ProgramCmd.mkdirs(this.outcordir);
        this.outmutdir = outdir;
        ProgramCmd.mkdirs(this.outmutdir);
        this.outpathodir = outdir;
        ProgramCmd.mkdirs(this.outpathodir);
        this.poolpath = this.outalndir + "/pool_" + FileName.baseName((String)tag) + ".rds";
        this.alnpath = this.outalndir + "/align_" + FileName.baseName((String)tag) + ".aln";
        this.mutpath = this.outmutdir + "/mutation_" + tag + ".mut";
        this.corpath = this.outmutdir + "/mutation-all_" + tag + ".mut";
        this.cortxtpath = this.outcordir + "/mutation-all_" + tag + ".txt";
        this.oncopath = this.outpathodir + "/mutation-oncogenic_" + tag + ".mut";
        this.oncotxtpath = this.outpathodir + "/mutation-oncogenic_" + tag + ".txt";
    }

    protected static String rand() {
        Random r = new Random();
        String ret = "";
        String alphabet = "1234567890abcdefghijklmnopqrstuvwxyz";
        for (int i = 0; i < 10; ++i) {
            ret = ret + alphabet.charAt(r.nextInt(alphabet.length()));
        }
        return ret;
    }

    @Override
    public void start() throws Exception {
        super.start();
        FileOp.unlinkAll((File)new File(this.outalndir), (boolean)true);
        new File(this.mutpath).delete();
        new File(this.corpath).delete();
        new File(this.oncopath).delete();
    }

    public static void help() {
        System.err.println();
        System.err.println("RNAmut - Version 1.2a");
        System.err.println("Usage: java <JAVA_OPTIONS> -jar RNAmut.jar <OPTIONS> FASTQ1_PATH,FASTQ2_PATH OUTPUT_DIR");
        System.err.println("Usage(Single-end): java <JAVA_OPTIONS> -jar RNAmut.jar <OPTIONS> FASTQ_PATH OUTPUT_DIR");
        System.err.println("Options:");
        System.err.println("         -i    Index file [default:index_AML-33genes.ind]");
        System.err.println("         -f    Oncogenicity filter [default:oncogenicity_filter.txt]");
        System.err.println("         -n    Sample name [default:Sample]");
        System.err.println("Example:");
        System.err.println("    java -Xms2g -Xmx2g -jar RNAmut.jar -n test_sample /scratch/test_1.fq.gz,/scratch/test_2.fq.gz /scratch/outdir");
        System.err.println();
    }

    protected static void check(String path) {
        if (!new File(path).exists()) {
            System.err.println("Error - file not exist: " + path);
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        String[] infs;
        Cmd c = new Cmd(args);
        String infstr = c.infs;
        String outdir = c.outdir;
        String tag = c.tag;
        String filtpath = c.onco;
        String indpath = c.index;
        for (String inf : infs = infstr.split(",")) {
            ProgramCmd.check(inf);
        }
        ProgramCmd.check(filtpath);
        ProgramCmd.check(indpath);
        Index index = IndexBuilder.read(indpath);
        System.out.println("Index loaded. ");
        PathogenicityFilter filt = new PathogenicityFilter(filtpath);
        Param par = new Param();
        ProgramCmd main = new ProgramCmd(new PrintWriter(System.out), Sys.DIR, infs, outdir, tag, index, filt, par);
        main.start();
    }

    static class Cmd {
        public String infs;
        public String outdir;
        public String index;
        public String onco;
        public String tag;
        public ArrayList<String> args = new ArrayList();
        private HashSet<String> as = new HashSet();

        public Cmd(String[] argsl) {
            System.err.println();
            this.args.addAll(Arrays.asList(argsl));
            this.as.addAll(Arrays.asList(FLAG_ONCO, FLAG_INDEX, FLAG_TAG));
            this.checkKnownArgs();
            this.checkDupArgs();
            this.index = this.get(FLAG_INDEX);
            this.index = this.index == null ? Sys.FILE_INDEX : this.index;
            this.onco = this.get(FLAG_ONCO);
            this.onco = this.onco == null ? Sys.FILE_ONCO : this.onco;
            this.tag = this.get(FLAG_TAG);
            String string = this.tag = this.tag == null ? "Sample" : this.tag;
            if (this.args.size() != 2) {
                System.err.println("Error - command line must give 2 arguments. (args:" + this.args.size() + ")");
                System.err.println("Arguments given: " + this.args);
                ProgramCmd.help();
                System.exit(1);
            }
            this.infs = this.args.get(0);
            this.outdir = this.args.get(1);
        }

        private String get(String flag) {
            for (int i = 0; i < this.args.size(); ++i) {
                if (!this.args.get(i).equals(flag)) continue;
                if (i < this.args.size() - 1) {
                    if (this.args.get(i + 1).charAt(0) != '-') {
                        String ret = this.args.get(i + 1);
                        this.args.remove(i + 1);
                        this.args.remove(i);
                        return ret;
                    }
                    System.err.println("Error - empty argument after " + flag);
                    System.exit(1);
                    continue;
                }
                System.err.println("Error - empty argument after " + flag);
                System.exit(1);
            }
            return null;
        }

        private void checkKnownArgs() {
            for (String arg : this.args) {
                if (arg.charAt(0) != '-' || this.as.contains(arg)) continue;
                System.err.println("Error - unknown flag " + arg);
                ProgramCmd.help();
                System.exit(1);
            }
        }

        private void checkDupArgs() {
            FrequencyCount fc = new FrequencyCount();
            for (String arg : this.args) {
                if (!this.as.contains(arg)) continue;
                fc.add((Object)arg);
            }
            for (String k : fc.keys()) {
                if (fc.getCount((Object)k) <= 1) continue;
                System.err.println("Error - duplicated flag: " + k);
                System.exit(1);
            }
        }
    }
}

