/*
 * Decompiled with CFR 0.152.
 */
package prog.core;

import fork.lib.base.FTimer;
import fork.lib.base.file.FileName;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import prog.Sys;
import prog.core.Param;
import prog.core.aln.Aligner;
import prog.core.aln.hot.DetectorFusion;
import prog.core.aln.hot.DetectorFusionPair;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.hot.DetectorITD;
import prog.core.aln.hot.VafCorrector;
import prog.core.aln.mut.MutationResult;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.aln.res.oncofilt.PathogenicityFilter;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;

public class ProgramMain {
    protected Writer wr;
    public String[] infs;
    protected Index index;
    protected Param par;
    protected PathogenicityFilter pathofilter;
    protected ReadPool pool;
    protected String outmutdir;
    protected String mutpath;
    protected String outalndir;
    protected String poolpath;
    protected String alnpath;
    protected String outcordir;
    protected String corpath;
    protected String cortxtpath;
    protected String outpathodir;
    protected String oncopath;
    protected String oncotxtpath;

    public ProgramMain() {
    }

    public ProgramMain(Writer wr, String dir, String[] infs, String outdir, String tag, Index index, PathogenicityFilter pathofilter, Param par) {
        this.wr = wr;
        this.infs = infs;
        this.index = index;
        this.par = par;
        if (this.par == null) {
            this.par = new Param();
        }
        this.pathofilter = pathofilter;
        ProgramMain.mkdirs(outdir);
        this.outalndir = outdir + "/align";
        ProgramMain.mkdirs(this.outalndir);
        this.outcordir = outdir + "/mut";
        ProgramMain.mkdirs(this.outcordir);
        this.outmutdir = outdir + "/mut";
        ProgramMain.mkdirs(this.outmutdir);
        this.outpathodir = outdir + "/mut";
        ProgramMain.mkdirs(this.outpathodir);
        this.poolpath = this.outalndir + "/pool_" + FileName.baseName((String)tag) + ".rds";
        this.alnpath = this.outalndir + "/align_" + FileName.baseName((String)tag) + ".aln";
        this.mutpath = this.outmutdir + "/mutation_" + tag + ".mut";
        this.corpath = this.outmutdir + "/mutation-corr_" + tag + ".mut";
        this.cortxtpath = this.outcordir + "/mutation-corr_" + tag + ".txt";
        this.oncopath = this.outpathodir + "/mutation-onco_" + tag + ".mut";
        this.oncotxtpath = this.outpathodir + "/mutation-onco_" + tag + ".txt";
    }

    public String dirOutaln() {
        return this.outalndir;
    }

    public String dirOutmut() {
        return this.outmutdir;
    }

    public String dirOutcorr() {
        return this.outcordir;
    }

    public String pathPool() {
        return this.poolpath;
    }

    public String pathAln() {
        return this.alnpath;
    }

    public String pathMut() {
        return this.mutpath;
    }

    public String pathCorr() {
        return this.corpath;
    }

    public String pathOnco() {
        return this.oncopath;
    }

    public void setWriter(Writer wr) {
        this.wr = wr;
    }

    protected static void mkdirs(String dir) {
        File dirf = new File(dir);
        if (!dirf.exists()) {
            dirf.mkdirs();
        }
    }

    public void writeln(String l) throws Exception {
        this.wr.write(l + "\n");
        this.wr.flush();
    }

    public void write(String l) throws Exception {
        this.wr.write(l);
        this.wr.flush();
    }

    public void close() throws Exception {
        this.wr.close();
    }

    public void align() throws Exception {
        this.writeln("Aligning in paired-end mode... " + Sys.timer.passedTime());
        Aligner alner = Aligner.AlignFastqPE(this.infs, this.poolpath, this.index, this.par, this.wr);
        AlignmentResult res = alner.result();
        res.write(this.alnpath);
        this.writeln("Alignment done! " + Sys.timer.passedTime());
    }

    public void alignSE() throws Exception {
        this.writeln("Aligning in single-end mode... " + Sys.timer.passedTime());
        Aligner alner = Aligner.AlignFastqSE(this.infs, this.poolpath, this.index, this.par, this.wr);
        AlignmentResult res = alner.result();
        res.write(this.alnpath);
        this.writeln("Alignment done! " + Sys.timer.passedTime());
    }

    public void callMutation() throws Exception {
        this.writeln("Start calling mutations ...");
        this.write("Loading read pool ... ");
        this.pool = ReadPool.read(this.poolpath);
        this.writeln("done! " + Sys.timer.passedTime());
        this.write("Reading alignments ... ");
        AlignmentResult res = AlignmentResult.read(this.alnpath, this.index, this.pool);
        this.writeln("done! " + Sys.timer.passedTime());
        this.write("Detecting substitutions, SNV & ITD ... ");
        DetectorHotspot hs = new DetectorHotspot(res, this.index, this.pool, this.par);
        hs.start();
        DetectorITD dd = new DetectorITD(res, this.index, this.pool, this.par);
        dd.start();
        this.writeln("done! " + Sys.timer.passedTime());
        this.write("Detecting gene fusions ... ");
        DetectorFusion ff = new DetectorFusion(res, this.index, this.pool, this.par);
        ff.start();
        DetectorFusionPair fp = new DetectorFusionPair(res, this.index, this.pool, this.par);
        fp.start();
        this.writeln("done! " + Sys.timer.passedTime());
        MutationResult mres = new MutationResult();
        mres.addAll(hs.result());
        mres.addAll(dd.result());
        mres.addAll(ff.result());
        mres.addAll(fp.result());
        mres.write(this.mutpath);
        this.writeln("Calling mutation complete! " + Sys.timer.passedTime());
    }

    public void correct() throws Exception {
        this.writeln("Running VAF correction ...");
        AlignmentResult res = AlignmentResult.read(this.alnpath, this.index, this.pool);
        MutationResult allmuts = MutationResult.read(this.mutpath);
        MutationResult mutout = new MutationResult();
        for (MutationSpot mut : allmuts.allMutations()) {
            String m = mut.toString();
            this.write("Correcting " + m + " ... ");
            VafCorrector cor = new VafCorrector(mut, mut.reconstructedTranscripts(this.index, this.par.mostFrequencReadLength()), this.par);
            cor.build();
            cor.correct(res, this.index, this.pool);
            mutout.addAll(cor.mutationResult());
            this.writeln("done! " + Sys.timer.passedTime());
        }
        mutout.labelMutations(this.pathofilter, this.index);
        mutout.write(this.corpath);
        MutationResult.writeToTxtFile(mutout, this.index, this.pool, this.cortxtpath, false);
        MutationResult respatho = mutout.filterSubset();
        respatho.write(this.oncopath);
        MutationResult.writeToTxtFile(respatho, this.index, this.pool, this.oncotxtpath, false);
        this.writeln("VAF correction complete! " + Sys.timer.passedTime());
    }

    public void start() throws Exception {
        Sys.timer = new FTimer();
        if (this.infs.length == 2) {
            this.align();
        } else {
            this.alignSE();
        }
        this.callMutation();
        this.correct();
    }

    public static void main(String[] args) throws Exception {
        String[] infs;
        String dir = args[0];
        String infstr = args[1];
        String outdir = args[2];
        String tag = args[3];
        String filtpath = null;
        String indpath = null;
        try {
            filtpath = args[4];
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            indpath = args[5];
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String inf : infs = infstr.split(",")) {
            if (new File(inf).exists()) continue;
            System.out.println("File not exist: " + inf);
            System.exit(1);
        }
        if (indpath == null) {
            indpath = dir + "/index_AML-33genes.ind";
        }
        Index index = IndexBuilder.read(indpath);
        System.out.println("Index loaded. ");
        PathogenicityFilter filt = filtpath == null ? new PathogenicityFilter(dir + "/oncogenicity_filter.txt") : new PathogenicityFilter(filtpath);
        Param par = new Param();
        ProgramMain main = new ProgramMain(new PrintWriter(System.out), dir, infs, outdir, tag, index, filt, par);
        main.start();
    }
}

