/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln;

import fork.lib.base.Counter;
import fork.lib.base.collection.Pair;
import fork.lib.base.file.FileName;
import fork.lib.bio.seq.parser.fastq.FastqEntry;
import fork.lib.bio.seq.parser.fastq.FastqReader;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import prog.Sys;
import prog.core.Param;
import prog.core.aln.Alignment;
import prog.core.aln.ReadAligner;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.Anchor;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.read.Seed;
import prog.core.aln.res.AlignmentResult;
import prog.core.index.Index;

public class Aligner {
    protected Index index;
    protected Param par;
    private AlignmentResult res = new AlignmentResult();

    public Aligner(Index index, Param par) {
        this.index = index;
        this.par = par;
        if (this.par == null) {
            this.par = new Param();
        }
    }

    public Aligner(Index index) {
        this(index, null);
    }

    public AlignmentResult result() {
        return this.res;
    }

    public static Aligner AlignFastqSE(String[] infns, String poolpath, Index index, Param par, Writer tawriter) throws Exception {
        ReadPool fw = new ReadPool(poolpath);
        Aligner alner = new Aligner(index, par);
        Counter cc = new Counter(1000000, "", " single-end reads mapped... ", tawriter, Sys.timer);
        int intid = 0;
        for (String infn : infns) {
            FastqEntry en;
            FastqReader fr;
            FastqReader fastqReader = fr = FileName.extension((String)infn).equals("gz") ? new FastqReader(infn, true) : new FastqReader(infn);
            while ((en = fr.nextEntry()) != null) {
                Read rd = new Read(++intid, en, par);
                par.readlens.add((Object)rd.length());
                if (par.ifVerbose) {
                    cc.count();
                }
                if (rd.length() < par.minReadLength) continue;
                ReadAligner rdalner = new ReadAligner(rd, index, par);
                Alignment aln = rdalner.bestAlignment();
                Aligner.addToResult(alner, new Alignment[]{aln}, new ReadAligner[]{rdalner}, index, par, fw);
            }
            fr.close();
        }
        fw.close();
        return alner;
    }

    public static Aligner AlignFastqPE(String[] infns, String poolpath, Index index, Param par, Writer tawriter) throws Exception {
        FastqEntry en1;
        ReadPool fw = new ReadPool(poolpath);
        Aligner alner = new Aligner(index, par);
        FastqReader fr1 = FileName.extension((String)infns[0]).equals("gz") ? new FastqReader(infns[0], true) : new FastqReader(infns[0]);
        FastqReader fr2 = FileName.extension((String)infns[1]).equals("gz") ? new FastqReader(infns[1], true) : new FastqReader(infns[1]);
        int id = -1;
        Counter cc = new Counter(1000000, "", " paired-end reads mapped... ", tawriter, Sys.timer);
        while ((en1 = fr1.nextEntry()) != null) {
            Read rd2;
            id += 2;
            if (par.ifVerbose) {
                cc.count();
            }
            FastqEntry en2 = fr2.nextEntry();
            Read rd1 = new Read(id, en1, par);
            if (rd1.length() < par.minReadLength || (rd2 = new Read(id + 1, en2, par)).length() < par.minReadLength) continue;
            try {
                par.readlens.add((Object)rd1.length());
                par.readlens.add((Object)rd2.length());
                ReadAligner rdalner1 = new ReadAligner(rd1, index, par);
                ReadAligner rdalner2 = new ReadAligner(rd2, index, par);
                ArrayList<Alignment> alns1 = rdalner1.alignments();
                ArrayList<Alignment> alns2 = rdalner2.alignments();
                if (alns1.isEmpty() && alns2.isEmpty()) continue;
                Pair<Alignment, Alignment> bpair = Aligner.bestPair(alns1, alns2, par);
                if (bpair == null) {
                    if (Aligner.addToPairedTranslocation(alner, alns1, alns2, rd1, rd2, index, par, fw)) continue;
                    if (rdalner1.bestAlignment() == null && !Aligner.addToResultITD(alner, rd1, rdalner1, index, par, fw)) {
                        Aligner.addToReadTranslocation(alner, rd1, rdalner1, index, par, fw, true);
                    }
                    if (rdalner2.bestAlignment() != null || Aligner.addToResultITD(alner, rd2, rdalner2, index, par, fw)) continue;
                    Aligner.addToReadTranslocation(alner, rd2, rdalner2, index, par, fw, true);
                    continue;
                }
                Alignment aln1 = (Alignment)bpair.a();
                Alignment aln2 = (Alignment)bpair.b();
                if (aln1 == null || aln2 == null) continue;
                Aligner.addToResult(alner, new Alignment[]{aln1, aln2}, new ReadAligner[]{rdalner1, rdalner2}, index, par, fw);
            }
            catch (Exception e) {
                System.err.println("Alignment Error:");
                System.err.println(rd1.sequence());
                System.err.println(rd2.sequence());
                e.printStackTrace();
            }
        }
        fw.close();
        fr1.close();
        fr2.close();
        return alner;
    }

    public static Aligner AlignPool(String poolpath, Index index, Param par) throws Exception {
        ReadPool pool = ReadPool.read(poolpath);
        Aligner alner = new Aligner(index, par);
        for (Read rd : pool) {
            ReadAligner rdalner = new ReadAligner(rd, index, par);
            Alignment aln = rdalner.bestAlignment();
            Aligner.addToResult(alner, new Alignment[]{aln}, new ReadAligner[]{rdalner}, index, par, null, false);
        }
        return alner;
    }

    public static void addToResult(Aligner alner, Alignment[] alns, ReadAligner[] rdalners, Index index, Param par, ReadPool fw) throws Exception {
        Aligner.addToResult(alner, alns, rdalners, index, par, fw, true);
    }

    public static void addToResult(Aligner alner, Alignment[] alns, ReadAligner[] rdalners, Index index, Param par, ReadPool fw, boolean ifw) throws Exception {
        for (int i = 0; i < alns.length; ++i) {
            Alignment aln = alns[i];
            ReadAligner rdalner = rdalners[i];
            Read rd = rdalner.read();
            if (aln != null) {
                alner.result().alignmentResult().addAlignment(aln);
                if (!ifw) continue;
                fw.write(rd);
                continue;
            }
            if (Aligner.addToResultITD(alner, rd, rdalner, index, par, fw, ifw)) continue;
            Aligner.addToReadTranslocation(alner, rd, rdalner, index, par, fw, ifw);
        }
    }

    public static boolean addToResultITD(Aligner alner, Read rd, ReadAligner rdalner, Index index, Param par, ReadPool fw) throws Exception {
        return Aligner.addToResultITD(alner, rd, rdalner, index, par, fw, true);
    }

    public static boolean addToResultITD(Aligner alner, Read rd, ReadAligner rdalner, Index index, Param par, ReadPool fw, boolean ifw) throws Exception {
        if (index.itdGenes.isEmpty()) {
            return false;
        }
        HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> ilocs = rdalner.iss();
        int n = -1;
        IsoformStrand iso = null;
        ArrayList<Pair<Seed, ArrayList<Integer>>> islocs = null;
        for (String is : ilocs.keySet()) {
            int s = ilocs.get(is).size();
            if (s <= n) continue;
            n = s;
            islocs = ilocs.get(is);
            iso = index.getIsoformStrand(is);
        }
        if (islocs != null && islocs.size() >= 2) {
            String isostr = iso.uniqueID();
            Anchor an = new Anchor(islocs, index, isostr, rd, par);
            if ((an.firstSize >= par.itdMapMinConsecutiveSeeds || an.lastSize >= par.itdMapMinConsecutiveSeeds) && index.itdGenes.contains(iso.geneID())) {
                alner.result().alignmentResultITD().addReadITD(iso.geneID(), isostr, rd, an);
                if (ifw) {
                    fw.write(rd);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean addToPairedTranslocation(Aligner alner, ArrayList<Alignment> alns1, ArrayList<Alignment> alns2, Read rd1, Read rd2, Index index, Param par, ReadPool fw) throws Exception {
        if (index.transPairs.isEmpty()) {
            return false;
        }
        for (Alignment a1 : alns1) {
            for (Alignment a2 : alns2) {
                Pair gpair = new Pair((Object)a1.isoformStrand().geneID(), (Object)a2.isoformStrand().geneID());
                if (!index.allPairPermutations.contains(gpair)) continue;
                alner.result().alignmentResultFusionPair().addAlignmentsTranslocation(a1, a2);
                fw.write(rd1);
                fw.write(rd2);
                return true;
            }
        }
        return false;
    }

    public static boolean addToReadTranslocation(Aligner alner, Read rd, ReadAligner rdalner, Index index, Param par, ReadPool fw, boolean ifw) throws Exception {
        if (index.transPairs.isEmpty()) {
            return false;
        }
        ArrayList<Pair<Seed, HashMap<String, ArrayList<Integer>>>> smap = rdalner.seedmaps();
        if (smap.get(0).b() == null || smap.get(smap.size() - 1).b() == null) {
            return false;
        }
        ArrayList<Pair> gpairs = new ArrayList<Pair>();
        ArrayList<Pair> isopairs = new ArrayList<Pair>();
        for (Object isostr : ((HashMap)smap.get(0).b()).keySet()) {
            String gid = index.getIsoformStrand((String)isostr).geneID();
            if (!index.transPairs.containsKey(gid)) continue;
            for (String isostr2 : ((HashMap)smap.get(smap.size() - 1).b()).keySet()) {
                String gid2 = index.getIsoformStrand(isostr2).geneID();
                if (!index.transPairs.get(gid).contains(gid2)) continue;
                gpairs.add(new Pair((Object)gid, (Object)gid2));
                isopairs.add(new Pair(isostr, (Object)isostr2));
            }
        }
        ArrayList<Pair> islocss = new ArrayList<Pair>();
        for (Pair gp : gpairs) {
            ArrayList<Pair<Seed, ArrayList<Integer>>> islocsa = new ArrayList<Pair<Seed, ArrayList<Integer>>>();
            ArrayList<Pair<Seed, ArrayList<Integer>>> islocsb = new ArrayList<Pair<Seed, ArrayList<Integer>>>();
            Aligner.addtotail(smap, islocsa, (String)gp.a(), index);
            Aligner.addtotail(smap, islocsb, (String)gp.b(), index);
            islocss.add(new Pair(islocsa, islocsb));
        }
        for (int i = 0; i < gpairs.size(); ++i) {
            Pair ip = (Pair)isopairs.get(i);
            Pair islocs2 = (Pair)islocss.get(i);
            Anchor an = new Anchor((ArrayList)islocs2.a(), (ArrayList)islocs2.b(), index, (String)ip.a(), (String)ip.b(), rd, par);
            if (an.firstSize < par.itdMapMinConsecutiveSeeds && an.lastSize < par.itdMapMinConsecutiveSeeds) continue;
            alner.result().alignmentResultFusionRead().addReadTranslocation(index.getIsoformStrand((String)ip.a()), index.getIsoformStrand((String)ip.b()), rd, an);
            if (ifw) {
                fw.write(rd);
            }
            return true;
        }
        return false;
    }

    public static void addtotail(ArrayList<Pair<Seed, HashMap<String, ArrayList<Integer>>>> smap, ArrayList<Pair<Seed, ArrayList<Integer>>> islocs, String tar, Index index) {
        for (Pair<Seed, HashMap<String, ArrayList<Integer>>> slocs : smap) {
            ArrayList locs = new ArrayList();
            if (slocs.b() != null) {
                for (String isostr : ((HashMap)slocs.b()).keySet()) {
                    String gid = index.getIsoformStrand(isostr).geneID();
                    if (!gid.equals(tar)) continue;
                    locs.addAll((Collection)((HashMap)slocs.b()).get(isostr));
                }
            }
            islocs.add((Pair<Seed, ArrayList<Integer>>)new Pair(slocs.a(), locs));
        }
    }

    public static Pair<Alignment, Alignment> bestPair(ArrayList<Alignment> alnsa, ArrayList<Alignment> alnsb, Param par) throws Exception {
        if (alnsa == null || alnsb == null) {
            return null;
        }
        ArrayList<Pair> ps = new ArrayList<Pair>();
        for (Alignment alna : alnsa) {
            for (Alignment alnb : alnsb) {
                if (!IsoformStrand.isPair(alna.isoformStrand(), alnb.isoformStrand())) continue;
                Region ra = alna.span();
                Region rb = alnb.span();
                int l = alnb.isoformStrand().sequence().length();
                Region rbr = new Region((double)l - rb.high(), (double)l - rb.low());
                double frag = ra.distanceFrom(rbr) + ra.getRange() + rb.getRange();
                if (!(frag < (double)par.peMaxFragmentSize)) continue;
                ps.add(new Pair((Object)alna, (Object)alnb));
            }
        }
        Collections.sort(ps, new Comparator<Pair<Alignment, Alignment>>(){

            @Override
            public int compare(Pair<Alignment, Alignment> o1, Pair<Alignment, Alignment> o2) {
                return Double.compare(((Alignment)o1.a()).mismatchScore() + ((Alignment)o1.b()).mismatchScore(), ((Alignment)o2.a()).mismatchScore() + ((Alignment)o2.b()).mismatchScore());
            }
        });
        return ps.isEmpty() ? null : (Pair)ps.get(0);
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

