/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln;

import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.AlignedElement;
import prog.core.aln.mut.AlignedMatch;
import prog.core.aln.mut.Deletion;
import prog.core.aln.mut.Insertion;
import prog.core.aln.mut.Mutation;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.Substitution;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.index.Index;

public class Alignment
implements Serializable {
    private String isostr;
    private int readID;
    private ArrayList<AlignedElement> eles = new ArrayList();
    private transient IsoformStrand iso;
    private transient double mmscore = Double.NEGATIVE_INFINITY;

    public Alignment(String isostr, Read read) {
        this.isostr = isostr;
        this.readID = read.intID();
    }

    public Alignment(IsoformStrand iso, Read read) {
        this(iso.uniqueID(), read);
        this.iso = iso;
    }

    public Alignment() {
    }

    public void initTransient(Index index, ReadPool pool) {
        this.iso = index.getIsoformStrand(this.isostr);
    }

    public void add(AlignedElement e) throws Exception {
        if (this.eles.isEmpty()) {
            this.eles.add(e);
            return;
        }
        AlignedElement pr = this.eles.get(this.eles.size() - 1);
        if (pr instanceof Deletion) {
            if (e instanceof Deletion) {
                if (pr.referenceRegion().high() != e.referenceRegion().low() - 1.0) {
                    System.err.println("del-del: " + pr + "  " + e);
                    throw new Exception();
                }
            } else if (e instanceof Insertion) {
                System.err.println("del-ins: " + pr + "  " + e);
                throw new Exception();
            }
        } else if (pr instanceof Insertion) {
            if (!(e instanceof Deletion) && e instanceof Insertion) {
                // empty if block
            }
        } else if (!(e instanceof Deletion || e instanceof Insertion || pr.referenceRegion().high() == e.referenceRegion().low() - 1.0 && pr.sequenceRegion().high() == e.sequenceRegion().low() - 1.0)) {
            System.err.println("mat-mat: " + pr + "  " + e);
            throw new Exception();
        }
        this.eles.add(e);
    }

    public Region span() throws Exception {
        Region rb = this.eles.get(0).referenceRegion();
        Region re = this.eles.get(this.eles.size() - 1).referenceRegion();
        return new Region(Math.min(rb.low(), re.low()), Math.max(rb.high(), re.high()));
    }

    public void print() {
        for (AlignedElement e : this.eles) {
            System.out.println(e);
        }
    }

    public void printMutation() throws Exception {
        this.printMutation("\n");
    }

    public void printMutation(String sep) throws Exception {
        for (AlignedElement e : this.eles) {
            if (!(e instanceof Mutation)) continue;
            MutationSpot ms = ((Mutation)e).mutationSpot(this.iso);
            System.out.print(ms.toString() + sep);
        }
    }

    public IsoformStrand isoformStrand() {
        return this.iso;
    }

    public String geneID() {
        return this.isoformStrand().geneID();
    }

    public void addMerge(AlignedElement e) throws Exception {
        this.add(e);
        this.merge();
    }

    public ArrayList<AlignedElement> elements() {
        return this.eles;
    }

    public int getReadID() {
        return this.readID;
    }

    public double mismatchScore() {
        if (this.mmscore == Double.NEGATIVE_INFINITY) {
            this.calculateMismatchScore();
        }
        return this.mmscore;
    }

    private void calculateMismatchScore() {
        this.mmscore = 0.0;
        for (AlignedElement e : this.eles) {
            if (e instanceof Insertion || e instanceof Deletion) {
                this.mmscore += 10.0;
                if (e instanceof Insertion) {
                    this.mmscore += (double)((Insertion)e).insertion().length();
                    continue;
                }
                if (!(e instanceof Deletion)) continue;
                this.mmscore += ((Deletion)e).referenceRegion().getRange() + 1.0;
                continue;
            }
            if (!(e instanceof Substitution)) continue;
            this.mmscore += 1.5;
        }
    }

    public int mutationNumber() {
        int n = 0;
        for (AlignedElement e : this.eles) {
            if (!(e instanceof Mutation)) continue;
            ++n;
        }
        return n;
    }

    public int mutationBases() {
        int n = 0;
        for (AlignedElement e : this.eles) {
            if (e instanceof Substitution) {
                n += (int)e.referenceRegion().getRange() + 1;
                continue;
            }
            if (e instanceof Insertion) {
                n += ((Insertion)e).insertion().length();
                continue;
            }
            if (!(e instanceof Deletion)) continue;
            n += (int)e.referenceRegion().getRange() + 1;
        }
        return n;
    }

    public void merge() throws Exception {
        ArrayList<AlignedElement> eles_ = new ArrayList<AlignedElement>();
        for (int i = 0; i < this.eles.size(); ++i) {
            Mutation nd;
            AlignedElement e = this.eles.get(i);
            if (eles_.isEmpty()) {
                eles_.add(e);
                continue;
            }
            AlignedElement prev = (AlignedElement)eles_.get(eles_.size() - 1);
            boolean ifadd = false;
            if (prev instanceof AlignedMatch && e instanceof AlignedMatch) {
                if (prev.referenceRegion().high() == e.referenceRegion().low() - 1.0 && prev.sequenceRegion().high() == e.sequenceRegion().low() - 1.0) {
                    AlignedMatch nm = new AlignedMatch(new int[]{(int)prev.sequenceRegion().low(), (int)e.sequenceRegion().high()}, new int[]{(int)prev.referenceRegion().low(), (int)e.referenceRegion().high()});
                    eles_.set(eles_.size() - 1, nm);
                } else {
                    ifadd = true;
                }
            } else if (prev instanceof Insertion && e instanceof Insertion) {
                if (((Insertion)prev).location() == ((Insertion)e).location() && prev.sequenceRegion().high() == e.sequenceRegion().low() - 1.0) {
                    Insertion ni = new Insertion((int)prev.sequenceRegion().low(), ((Insertion)e).location(), ((Insertion)prev).insertion() + ((Insertion)e).insertion());
                    eles_.set(eles_.size() - 1, ni);
                } else {
                    ifadd = true;
                }
            } else if (prev instanceof Deletion && e instanceof Deletion) {
                if (prev.referenceRegion().high() == e.referenceRegion().low() - 1.0) {
                    nd = new Deletion((int)prev.referenceRegion().low(), (int)e.referenceRegion().high());
                    eles_.set(eles_.size() - 1, nd);
                } else {
                    ifadd = true;
                }
            } else if (prev instanceof Substitution && e instanceof Substitution) {
                if (prev.referenceRegion().high() == e.referenceRegion().low() - 1.0) {
                    nd = new Substitution((int)prev.sequenceRegion().low(), (int)prev.referenceRegion().low(), ((Substitution)prev).substitutionChars() + ((Substitution)e).substitutionChars(), ((Substitution)prev).originalChars() + ((Substitution)e).originalChars());
                    eles_.set(eles_.size() - 1, nd);
                } else {
                    ifadd = true;
                }
            } else {
                ifadd = true;
            }
            if (!ifadd) continue;
            eles_.add(e);
        }
        this.eles = eles_;
    }

    public void reorder(Read rd) throws Exception {
        if (this.iso.isForward()) {
            for (int i = 1; i < this.eles.size() - 1; ++i) {
                AlignedElement pr = this.eles.get(i - 1);
                AlignedElement pn = this.eles.get(i + 1);
                if (!(pr instanceof AlignedMatch) || !(pn instanceof AlignedMatch)) continue;
                AlignedElement ele = this.eles.get(i);
                if (ele instanceof Deletion) {
                    this.reorderDeletionForward(i, pr, ele, pn, rd);
                    continue;
                }
                if (!(ele instanceof Insertion)) continue;
                this.reorderInsertionForward(i, pr, ele, pn, rd);
            }
        } else {
            for (int i = 1; i < this.eles.size() - 1; ++i) {
                AlignedElement pr = this.eles.get(i - 1);
                AlignedElement pn = this.eles.get(i + 1);
                if (!(pr instanceof AlignedMatch) || !(pn instanceof AlignedMatch)) continue;
                AlignedElement ele = this.eles.get(i);
                if (ele instanceof Deletion) {
                    this.reorderDeletionReverse(i, pr, ele, pn, rd);
                    continue;
                }
                if (!(ele instanceof Insertion)) continue;
                this.reorderInsertionReverse(i, pr, ele, pn, rd);
            }
        }
    }

    private void reorderDeletionForward(int i, AlignedElement pr, AlignedElement ele, AlignedElement pn, Read read) throws Exception {
        int shift = 0;
        while (true) {
            int sind = (int)pr.sequenceRegion().high() - shift;
            int rind = (int)ele.referenceRegion().high() - shift;
            if (sind < 0 || (double)sind <= pr.sequenceRegion().low() || rind < 0 || (double)rind <= pr.referenceRegion().low() || read.sequence().charAt(sind) != this.iso.sequence().charAt(rind)) break;
            ++shift;
        }
        if (shift > 0) {
            this.eles.set(i - 1, new AlignedMatch(pr.sequenceRegion().low(), pr.sequenceRegion().high() - (double)shift, pr.referenceRegion().low(), pr.referenceRegion().high() - (double)shift));
            this.eles.set(i, new Deletion(ele.referenceRegion().low() - (double)shift, ele.referenceRegion().high() - (double)shift));
            this.eles.set(i + 1, new AlignedMatch(pn.sequenceRegion().low() - (double)shift, pn.sequenceRegion().high(), pn.referenceRegion().low() - (double)shift, pn.referenceRegion().high()));
        }
    }

    private void reorderInsertionForward(int i, AlignedElement pr, AlignedElement ele, AlignedElement pn, Read read) throws Exception {
        int shift = 0;
        while (true) {
            int sind = (int)ele.sequenceRegion().high() - shift;
            int rind = (int)pr.referenceRegion().high() - shift;
            if (sind < 0 || (double)sind <= pr.sequenceRegion().low() || rind < 0 || (double)rind <= pr.referenceRegion().low() || read.sequence().charAt(sind) != this.iso.sequence().charAt(rind)) break;
            ++shift;
        }
        if (shift > 0) {
            Insertion ins = (Insertion)ele;
            int low = (int)ins.sequenceRegion().low() - shift;
            this.eles.set(i - 1, new AlignedMatch(pr.sequenceRegion().low(), pr.sequenceRegion().high() - (double)shift, pr.referenceRegion().low(), pr.referenceRegion().high() - (double)shift));
            this.eles.set(i, new Insertion((int)ele.sequenceRegion().low() - shift, ins.location() - shift, read.sequence().substring(low, low + ins.insertion().length())));
            this.eles.set(i + 1, new AlignedMatch(pn.sequenceRegion().low() - (double)shift, pn.sequenceRegion().high(), pn.referenceRegion().low() - (double)shift, pn.referenceRegion().high()));
        }
    }

    private void reorderDeletionReverse(int i, AlignedElement pr, AlignedElement ele, AlignedElement pn, Read read) throws Exception {
        int shift = 0;
        while (true) {
            int sind = (int)pn.sequenceRegion().low() + shift;
            int rind = (int)ele.referenceRegion().low() + shift;
            if (sind >= read.sequence().length() || (double)sind >= pn.sequenceRegion().high() || rind >= this.iso.sequence().length() || (double)sind >= pn.referenceRegion().high() || read.sequence().charAt(sind) != this.iso.sequence().charAt(rind)) break;
            ++shift;
        }
        if (shift > 0) {
            this.eles.set(i - 1, new AlignedMatch(pr.sequenceRegion().low(), pr.sequenceRegion().high() + (double)shift, pr.referenceRegion().low(), pr.referenceRegion().high() + (double)shift));
            this.eles.set(i, new Deletion(ele.referenceRegion().low() + (double)shift, ele.referenceRegion().high() + (double)shift));
            this.eles.set(i + 1, new AlignedMatch(pn.sequenceRegion().low() + (double)shift, pn.sequenceRegion().high(), pn.referenceRegion().low() + (double)shift, pn.referenceRegion().high()));
        }
    }

    private void reorderInsertionReverse(int i, AlignedElement pr, AlignedElement ele, AlignedElement pn, Read read) throws Exception {
        int shift = 0;
        while (true) {
            int sind = (int)ele.sequenceRegion().low() + shift;
            int rind = (int)pn.referenceRegion().low() + shift;
            if (sind >= read.sequence().length() || (double)sind >= pn.sequenceRegion().high() || rind >= this.iso.sequence().length() || (double)rind >= pn.referenceRegion().high() || read.sequence().charAt(sind) != this.iso.sequence().charAt(rind)) break;
            ++shift;
        }
        if (shift > 0) {
            Insertion ins = (Insertion)ele;
            int low = (int)ins.sequenceRegion().low() + shift;
            this.eles.set(i - 1, new AlignedMatch(pr.sequenceRegion().low(), pr.sequenceRegion().high() + (double)shift, pr.referenceRegion().low(), pr.referenceRegion().high() + (double)shift));
            this.eles.set(i, new Insertion((int)ele.sequenceRegion().low() + shift, ins.location() + shift, read.sequence().substring(low, low + ins.insertion().length())));
            this.eles.set(i + 1, new AlignedMatch(pn.sequenceRegion().low() + (double)shift, pn.sequenceRegion().high(), pn.referenceRegion().low() + (double)shift, pn.referenceRegion().high()));
        }
    }

    public void printAlignmentLocation() {
        int low = (int)this.eles.get(0).referenceRegion().low();
        int high = (int)this.eles.get(0).referenceRegion().high();
        System.out.println(this.iso.chr() + ":" + this.iso.location(low) + "-" + this.iso.location(high));
    }

    public String reconstruct(MutationSpot mut) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (AlignedElement e : this.eles) {
            boolean ifadd = false;
            if (e instanceof Mutation) {
                if (((Mutation)e).genomicLocation(this.iso).equals(mut.toString())) {
                    if (e instanceof Insertion) {
                        sb.append(((Insertion)e).insertion());
                    } else if (e instanceof Substitution) {
                        sb.append(((Substitution)e).substitutionChars());
                    }
                } else if (!(e instanceof Insertion)) {
                    ifadd = true;
                }
            } else {
                ifadd = true;
            }
            if (!ifadd) continue;
            sb.append(this.iso.sequence().subSequence((int)e.referenceRegion().low(), (int)e.referenceRegion().high() + 1));
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

