/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln;

import fork.lib.base.collection.Pair;
import fork.lib.bio.seq.align.NeedlemanWunsch;
import java.util.ArrayList;
import prog.core.Param;
import prog.core.aln.Alignment;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.AlignedMatch;
import prog.core.aln.mut.Deletion;
import prog.core.aln.mut.Insertion;
import prog.core.aln.mut.Substitution;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadShrink;
import prog.core.aln.read.Seed;
import prog.core.index.Index;

public class GapAligner {
    private Index index;
    private IsoformStrand iso;
    private Read read;
    private ArrayList<Pair<Seed, Integer>> mseeds;
    private Param par;

    public GapAligner(Index index, IsoformStrand iso, Read read, ArrayList<Pair<Seed, Integer>> mseeds, Param par) {
        this.index = index;
        this.iso = iso;
        this.read = read;
        this.mseeds = mseeds;
        this.par = par;
    }

    public Alignment align() throws Exception {
        Alignment aln = new Alignment(this.iso, this.read);
        boolean ifc = false;
        for (int i = 0; i < this.mseeds.size(); ++i) {
            boolean ifgood;
            Pair<Seed, Integer> ms = this.mseeds.get(i);
            Seed sd = (Seed)ms.a();
            int loc = (Integer)ms.b();
            if (i == 0 && sd.index() > 0 && !(ifgood = this.leftGap(aln, this.read.sequence(), sd.index(), this.iso.sequence(), loc))) {
                return null;
            }
            if (i < this.mseeds.size() - 1) {
                boolean ifc_;
                int posn;
                Pair<Seed, Integer> msn = this.mseeds.get(i + 1);
                Seed sdn = (Seed)msn.a();
                int loch = loc + this.index.kmer();
                int locn = (Integer)msn.b();
                int posh = sd.index() + this.index.kmer();
                if (posh == (posn = sdn.index())) {
                    if (loch < locn) {
                        this.match(aln, sd.index(), loc);
                        ifc_ = GapAligner.gap(aln, this.read.sequence(), new int[]{sd.index() + this.index.kmer(), sdn.index()}, this.iso.sequence(), new int[]{loch, locn}, this.iso);
                        ifc = ifc || ifc_;
                        continue;
                    }
                    if (loch > locn) {
                        int off = loch - locn;
                        int inspos = posh - off;
                        aln.add(new AlignedMatch(sd.index(), inspos - 1, loc, locn - 1));
                        aln.add(new Insertion(inspos, locn, this.read.sequence().substring(inspos, sdn.index())));
                        ifc = true;
                        continue;
                    }
                    this.match(aln, sd.index(), loc);
                    continue;
                }
                if (loch < locn) {
                    this.match(aln, sd.index(), loc);
                    ifc_ = GapAligner.gap(aln, this.read.sequence(), new int[]{sd.index() + this.index.kmer(), sdn.index()}, this.iso.sequence(), new int[]{loch, locn}, this.iso);
                    ifc = ifc || ifc_;
                    continue;
                }
                return null;
            }
            this.match(aln, sd.index(), loc);
            if (sd.index() + this.index.kmer() >= this.read.length() || (ifgood = this.rightGap(aln, this.read.sequence(), sd.index() + this.index.kmer(), this.iso.sequence(), loc + this.index.kmer()))) continue;
            return null;
        }
        aln.merge();
        if (ifc && !this.checkAlign(aln)) {
            return null;
        }
        if (!this.checkAlign(aln)) {
            return null;
        }
        aln.reorder(this.read);
        return aln;
    }

    private boolean checkAlign(Alignment aln) {
        return aln.mutationNumber() <= this.par.maxMutationsPerTranscript && aln.mutationBases() <= this.par.maxMutatedBases;
    }

    private boolean leftGap(Alignment aln, String seqstr, int pos, String refstr, int loc) throws Exception {
        int len = Math.min(pos, loc);
        return this.end(aln, seqstr, pos - len, refstr, loc - len, len, 10);
    }

    private boolean rightGap(Alignment aln, String seqstr, int pos, String refstr, int loc) throws Exception {
        int len = Math.min(seqstr.length() - pos, refstr.length() - loc);
        return this.end(aln, seqstr, pos, refstr, loc, len, 10);
    }

    private boolean end(Alignment aln, String seqstr, int pos, String refstr, int loc, int len, int thr) throws Exception {
        String seq = seqstr.substring(pos, pos + len);
        String ref = refstr.substring(loc, loc + len);
        if (len == 0) {
            return true;
        }
        if (this.par.ifAlignEnds) {
            GapAligner.gap(aln, seqstr, new int[]{pos, pos + len}, refstr, new int[]{loc, loc + len}, this.iso);
            return true;
        }
        int mm = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == ref.charAt(i)) continue;
            ++mm;
        }
        if (mm > thr) {
            return false;
        }
        aln.add(new AlignedMatch(new int[]{pos, pos + len - 1}, new int[]{loc, loc + len - 1}));
        return true;
    }

    private void match(Alignment aln, int pos, int loc) throws Exception {
        aln.add(new AlignedMatch(new int[]{pos, pos + this.index.kmer() - 1}, new int[]{loc, loc + this.index.kmer() - 1}));
    }

    public static boolean gap(Alignment aln, String seqstr, int[] poslh, String refstr, int[] loclh, IsoformStrand iso) throws Exception {
        String seq = seqstr.substring(poslh[0], poslh[1]);
        String ref = refstr.substring(loclh[0], loclh[1]);
        boolean ifmut = false;
        ReadShrink rs = new ReadShrink(ref, seq);
        if (iso.isForward()) {
            rs.computeRight();
            rs.computeLeft();
        } else {
            rs.computeLeft();
            rs.computeRight();
        }
        String seqr = rs.sequenceRemain();
        String refr = rs.referenceRemain();
        if (!rs.left().isEmpty()) {
            aln.add(new AlignedMatch(new int[]{poslh[0], poslh[0] + rs.left().length() - 1}, new int[]{loclh[0], loclh[0] + rs.left().length() - 1}));
        }
        if (seqr.isEmpty()) {
            if (!refr.isEmpty()) {
                aln.add(new Deletion(loclh[0] + rs.left().length(), loclh[0] + rs.left().length() + refr.length() - 1));
            }
        } else if (refr.isEmpty()) {
            aln.add(new Insertion(poslh[0] + rs.left().length(), loclh[0] + rs.left().length(), seqr));
        } else {
            int pl = poslh[0] + rs.left().length();
            int ll = loclh[0] + rs.left().length();
            if (seqr.length() == refr.length()) {
                for (int i = 0; i < seqr.length(); ++i) {
                    if (seqr.charAt(i) == refr.charAt(i)) {
                        aln.add(new AlignedMatch(pl + i, ll + i));
                        continue;
                    }
                    aln.add(new Substitution(pl + i, ll + i, seqr.charAt(i), refr.charAt(i)));
                    ifmut = true;
                }
            } else {
                ifmut = true;
                NeedlemanWunsch nw = new NeedlemanWunsch(seqr, refr);
                nw.compute();
                Pair<String, String> bestnw = GapAligner.bestNeedlemanWunsch(nw.alignments(), iso);
                String nwseq = (String)bestnw.a();
                String nwref = (String)bestnw.b();
                int lind = 0;
                int hind = nwseq.length() - 1;
                int seqind = pl;
                int refind = ll;
                for (int i = 0; i < nwseq.length(); ++i) {
                    boolean ifadd = i >= lind && i <= hind;
                    char s = nwseq.charAt(i);
                    char r = nwref.charAt(i);
                    if (r == '-') {
                        if (ifadd) {
                            aln.add(new Insertion(seqind, refind, Character.toString(s)));
                        }
                        ++seqind;
                        continue;
                    }
                    if (s == '-') {
                        if (ifadd) {
                            aln.add(new Deletion(refind, refind));
                        }
                        ++refind;
                        continue;
                    }
                    if (ifadd) {
                        if (r == s) {
                            aln.add(new AlignedMatch(seqind, refind));
                        } else {
                            aln.add(new Substitution(seqind, refind, s, r));
                        }
                    }
                    ++refind;
                    ++seqind;
                }
            }
        }
        if (!rs.right().isEmpty()) {
            GapAligner.addRightMatch(aln, rs.right(), loclh[1], poslh[1]);
        }
        return ifmut;
    }

    private static void addRightMatch(Alignment aln, String right, int loc, int pos) throws Exception {
        aln.add(new AlignedMatch(new int[]{pos - right.length(), pos - 1}, new int[]{loc - right.length(), loc - 1}));
    }

    private static Pair<String, String> bestNeedlemanWunsch(ArrayList<Pair<String, String>> nws, IsoformStrand iso) {
        double minv = Double.POSITIVE_INFINITY;
        double maxv = Double.NEGATIVE_INFINITY;
        int minind = -1;
        int maxind = -1;
        for (int i = 0; i < nws.size(); ++i) {
            int j;
            Pair<String, String> p = nws.get(i);
            double score = 0.0;
            for (j = 0; j < ((String)p.a()).length(); ++j) {
                if (((String)p.a()).charAt(j) != '-') continue;
                score += 1.0 / (double)(1 + j);
            }
            for (j = 0; j < ((String)p.b()).length(); ++j) {
                if (((String)p.b()).charAt(j) != '-') continue;
                score += 1.0 / (double)(1 + j);
            }
            if (score < minv) {
                minv = score;
                minind = i;
            }
            if (!(score > maxv)) continue;
            maxv = score;
            maxind = i;
        }
        if (iso.isForward()) {
            return nws.get(minind);
        }
        return nws.get(maxind);
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

