/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln;

import fork.lib.base.collection.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import prog.core.Param;
import prog.core.aln.Alignment;
import prog.core.aln.GapAligner;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.read.Read;
import prog.core.aln.read.Seed;
import prog.core.index.Index;

public class ReadAligner {
    private static Comparator<Alignment> comp = new Comparator<Alignment>(){

        @Override
        public int compare(Alignment o1, Alignment o2) {
            return Double.compare(o1.mismatchScore(), o2.mismatchScore());
        }
    };
    private static Comparator<Pair<Seed, Integer>> seedcomp = new Comparator<Pair<Seed, Integer>>(){

        @Override
        public int compare(Pair<Seed, Integer> o1, Pair<Seed, Integer> o2) {
            return Integer.compare(((Seed)o1.a()).index(), ((Seed)o2.a()).index());
        }
    };
    private Read read;
    private Index index;
    private Param par;
    private ArrayList<Pair<Seed, HashMap<String, ArrayList<Integer>>>> seedmaps = new ArrayList();
    private HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> iss;
    private HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> isg;
    private HashMap<String, ArrayList<ArrayList<Pair<Seed, Integer>>>> isord;
    private ArrayList<Alignment> alns = new ArrayList();
    private Alignment bestaln = null;
    private boolean ifstart = false;
    private boolean ifbestaln = false;

    public ReadAligner(Read read, Index index, Param par) {
        this.read = read;
        this.index = index;
        this.par = par;
    }

    public HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> iss() {
        return this.iss;
    }

    public ArrayList<Pair<Seed, HashMap<String, ArrayList<Integer>>>> seedmaps() {
        return this.seedmaps;
    }

    public Read read() {
        return this.read;
    }

    public boolean startAlign() throws Exception {
        this.ifstart = true;
        if (this.read.seeds() == null) {
            this.read.initSeedSet(this.index.kmer());
        }
        this.seedmaps = this.seedmaps(this.index, this.par);
        this.iss = this.mapSeedsToIsoform(this.index, this.par);
        if (this.iss.isEmpty()) {
            return false;
        }
        this.isg = this.selectGoodSeedMap(this.iss, this.par);
        if (this.isg.isEmpty()) {
            return false;
        }
        this.isord = this.matchOrder(this.isg, this.par, this.index.kmer());
        if (this.isord == null || this.isord.isEmpty()) {
            return false;
        }
        for (String iso : this.isord.keySet()) {
            for (ArrayList<Pair<Seed, Integer>> locs : this.isord.get(iso)) {
                GapAligner ga = new GapAligner(this.index, this.index.getIsoformStrand(iso), this.read, locs, this.par);
                Alignment aln = ga.align();
                if (aln == null) continue;
                this.alns.add(aln);
            }
        }
        return true;
    }

    public ArrayList<Pair<Seed, HashMap<String, ArrayList<Integer>>>> seedmaps(Index index, Param par) throws Exception {
        ArrayList<Pair<Seed, HashMap<String, ArrayList<Integer>>>> ret = new ArrayList<Pair<Seed, HashMap<String, ArrayList<Integer>>>>();
        for (int i = 0; i < this.read.seeds().size(); ++i) {
            Seed sd = this.read.seeds().get(i);
            HashMap<String, ArrayList<Integer>> ilocs = sd.align(index, par);
            ret.add((Pair<Seed, HashMap<String, ArrayList<Integer>>>)new Pair((Object)sd, ilocs));
        }
        return ret;
    }

    public HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> mapSeedsToIsoform(Index index, Param par) throws Exception {
        HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> iseeds = new HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>>();
        for (int i = 0; i < this.seedmaps.size(); ++i) {
            Seed sd = (Seed)this.seedmaps.get(i).a();
            HashMap ilocs = (HashMap)this.seedmaps.get(i).b();
            if (ilocs == null) continue;
            for (String iso : ilocs.keySet()) {
                if (!iseeds.containsKey(iso)) {
                    iseeds.put(iso, new ArrayList());
                }
                iseeds.get(iso).add((Pair<Seed, ArrayList<Integer>>)new Pair((Object)sd, ilocs.get(iso)));
            }
        }
        return iseeds;
    }

    public HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> selectGoodSeedMap(HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> iseeds, Param par) throws Exception {
        HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> iseedsg = new HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>>();
        int thr = Math.max(par.minMappedSeeds, (int)Math.ceil(par.minMappedSeedsFraction * (double)this.read.seeds().size()));
        for (String iso : iseeds.keySet()) {
            ArrayList<Pair<Seed, ArrayList<Integer>>> seeds = iseeds.get(iso);
            if (seeds.size() < thr) continue;
            iseedsg.put(iso, seeds);
        }
        return iseedsg;
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, ArrayList<ArrayList<Pair<Seed, Integer>>>> matchOrder(HashMap<String, ArrayList<Pair<Seed, ArrayList<Integer>>>> isg, Param par, int kmer) throws Exception {
        HashMap<String, ArrayList<ArrayList<Pair<Seed, Integer>>>> ret = new HashMap<String, ArrayList<ArrayList<Pair<Seed, Integer>>>>();
        for (String iso : isg.keySet()) {
            void var13_16;
            ArrayList<Pair<Seed, ArrayList<Integer>>> glis = isg.get(iso);
            HashMap valismap = new HashMap();
            int thr = Math.max(par.minOrderedSeeds, (int)Math.floor((double)glis.size() * par.minOrderedSeedsFraction));
            ArrayList<Pair<Seed, Integer>> uniseeds = new ArrayList<Pair<Seed, Integer>>();
            ArrayList<Pair<Seed, ArrayList<Integer>>> mulseeds = new ArrayList<Pair<Seed, ArrayList<Integer>>>();
            for (Pair<Seed, ArrayList<Integer>> pair : glis) {
                if (((ArrayList)pair.b()).size() == 1) {
                    uniseeds.add((Pair<Seed, Integer>)new Pair(pair.a(), ((ArrayList)pair.b()).get(0)));
                    continue;
                }
                mulseeds.add(pair);
            }
            if (uniseeds.size() < par.minUniqueMappedSeeds || !this.uniqueSeedsOrder(uniseeds, par)) continue;
            ArrayList<Pair<Seed, Integer>> locseeds = new ArrayList<Pair<Seed, Integer>>();
            locseeds.addAll(uniseeds);
            for (Pair p : mulseeds) {
                Pair<Seed, Integer> sind = this.bestMatchingOrder((Pair<Seed, ArrayList<Integer>>)p, uniseeds, par);
                if (sind == null) continue;
                locseeds.add(sind);
            }
            locseeds.sort(seedcomp);
            boolean bl = false;
            while (var13_16 < locseeds.size() - 1) {
                Pair p;
                p = (Pair)locseeds.get((int)var13_16);
                Pair pn = (Pair)locseeds.get((int)(var13_16 + true));
                if (((Seed)pn.a()).index() - ((Seed)p.a()).index() <= kmer) {
                    if ((Integer)pn.b() - (Integer)p.b() - (((Seed)pn.a()).index() - ((Seed)p.a()).index()) < 0) {
                        locseeds.remove((int)(var13_16 + true));
                        --var13_16;
                    }
                } else if (this.seedsDistanceBad((Pair<Seed, Integer>)p, (Pair<Seed, Integer>)pn, par)) {
                    locseeds.remove((int)(var13_16 + true));
                    --var13_16;
                }
                ++var13_16;
            }
            if (locseeds.size() < thr) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> ls = new ArrayList<Object>();
            for (Pair pair : locseeds) {
                arrayList.add(pair.a());
                ls.add(pair.b());
            }
            if (!valismap.containsKey(ls)) {
                valismap.put(ls, arrayList);
            }
            ArrayList arrayList2 = new ArrayList();
            for (ArrayList keys : valismap.keySet()) {
                ArrayList arrayList3 = (ArrayList)valismap.get(keys);
                ArrayList<Pair> ps = new ArrayList<Pair>();
                for (int i = 0; i < keys.size(); ++i) {
                    ps.add(new Pair(arrayList3.get(i), keys.get(i)));
                }
                arrayList2.add(ps);
            }
            ret.put(iso, arrayList2);
        }
        return ret;
    }

    private boolean uniqueSeedsOrder(ArrayList<Pair<Seed, Integer>> us, Param par) {
        for (int i = 0; i < us.size() - 1; ++i) {
            Pair<Seed, Integer> un;
            Pair<Seed, Integer> u = us.get(i);
            if (!this.seedsDistanceBad(u, un = us.get(i + 1), par)) continue;
            return false;
        }
        return true;
    }

    private boolean seedsDistanceBad(Pair<Seed, Integer> u, Pair<Seed, Integer> un, Param par) {
        int diff = (Integer)un.b() - (Integer)u.b() - (((Seed)un.a()).index() - ((Seed)u.a()).index());
        return diff > par.maxDeletion || diff < -par.maxInsertion;
    }

    private Pair<Seed, Integer> bestMatchingOrder(Pair<Seed, ArrayList<Integer>> tar, ArrayList<Pair<Seed, Integer>> us, Param par) throws Exception {
        Pair ret = null;
        int mindis = Integer.MAX_VALUE;
        block0: for (Integer loc : (ArrayList)tar.b()) {
            int dis = 0;
            int ind = ((Seed)tar.a()).index();
            for (Pair<Seed, Integer> up : us) {
                int d = (Integer)up.b() - loc - (((Seed)up.a()).index() - ind);
                if (d > par.maxDeletion || d < -par.maxInsertion) continue block0;
                dis += Math.abs(d);
            }
            if (dis >= mindis) continue;
            mindis = dis;
            ret = new Pair(tar.a(), (Object)loc);
        }
        return ret;
    }

    public Alignment bestAlignment() throws Exception {
        if (this.ifbestaln) {
            return this.bestaln;
        }
        ArrayList<Alignment> alns_ = this.alignments();
        if (alns_ == null || alns_.isEmpty()) {
            return null;
        }
        Collections.sort(alns_, comp);
        this.bestaln = alns_.get(0);
        return this.bestaln;
    }

    public ArrayList<Alignment> alignments() throws Exception {
        if (this.ifstart) {
            return this.alns;
        }
        this.startAlign();
        return this.alns;
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

