/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.ele;

import fork.lib.base.collection.Pair;
import fork.lib.bio.seq.region.GenomicRegion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import prog.core.aln.ele.Isoform;
import prog.core.aln.ele.TranscriptFragmentSet;

public class Gene
implements Serializable {
    private String id;
    private String chr;
    private char std;
    private int low = Integer.MAX_VALUE;
    private int high = Integer.MIN_VALUE;
    private ArrayList<Isoform> isos = new ArrayList();

    public Gene(String id, String chr, char std) {
        this.id = id;
        this.chr = chr;
        this.std = std;
    }

    public String ID() {
        return this.id;
    }

    public String chr() {
        return this.chr;
    }

    public char strand() {
        return this.std;
    }

    public ArrayList<Isoform> isoforms() {
        return this.isos;
    }

    public boolean isOnForwardStrnd() {
        return this.std == '+';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Gene other = (Gene)obj;
        if (this.std != other.std) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.chr, other.chr);
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + Objects.hashCode(this.id);
        hash = 43 * hash + Objects.hashCode(this.chr);
        hash = 43 * hash + this.std;
        return hash;
    }

    public void addTranscript(TranscriptFragmentSet frag) throws Exception {
        Isoform is = new Isoform(this, frag.transcriptID(), frag.lowHighs(), frag.codons());
        is.initChildren(frag.sequence());
        this.isos.add(is);
        Pair<Integer, Integer> lh = frag.getLowHigh();
        this.low = Math.min(this.low, (Integer)lh.a());
        this.high = Math.max(this.high, (Integer)lh.b());
    }

    public GenomicRegion toGenomicRegion() {
        try {
            return new GenomicRegion(this.chr, this.low, this.high);
        }
        catch (Exception e) {
            return null;
        }
    }
}

