/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.ele;

import fork.lib.base.collection.Pair;
import fork.lib.bio.seq.Nucleotide;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import prog.core.aln.ele.Gene;
import prog.core.aln.ele.IsoformStrand;

public class Isoform
implements Serializable {
    private Gene parent;
    private String id;
    private IsoformStrand ise;
    private IsoformStrand ias;
    private ArrayList<Pair<Integer, Integer>> lhs;
    private Pair<Integer, Integer> codons;

    public Isoform(Gene parent, String id, ArrayList<Pair<Integer, Integer>> lhs, Pair<Integer, Integer> codons) {
        this.parent = parent;
        this.id = id;
        this.lhs = lhs;
        this.codons = codons;
    }

    public void initChildren(String seq) throws Exception {
        this.ise = new IsoformStrand(this, 's', seq);
        this.ias = new IsoformStrand(this, 'a', Nucleotide.reverseComplement((String)seq));
    }

    public String ID() {
        return this.id;
    }

    public String geneID() {
        return this.parent.ID();
    }

    public String chr() {
        return this.parent.chr();
    }

    public char strand() {
        return this.parent.strand();
    }

    public IsoformStrand strandSense() {
        return this.ise;
    }

    public IsoformStrand strandAntisense() {
        return this.ias;
    }

    public Gene parent() {
        return this.parent;
    }

    public ArrayList<Pair<Integer, Integer>> lhs() {
        return this.lhs;
    }

    public Pair<Integer, Integer> codons() {
        return this.codons;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Isoform other = (Isoform)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.parent, other.parent);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.parent);
        hash = 29 * hash + Objects.hashCode(this.id);
        return hash;
    }
}

