/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.ele;

import fork.lib.base.collection.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import prog.core.aln.ele.Isoform;

public class IsoformStrand
implements Serializable {
    protected Isoform parent;
    protected char sas;
    protected String seq;
    protected String uid;
    protected HashMap<Integer, Integer> pos2loc = new HashMap();
    private Pair<Integer, Integer> cinds;

    public IsoformStrand(Isoform parent, char sas, String seq) {
        this.sas = sas;
        this.seq = seq;
        this.parent = parent;
        this.init();
    }

    protected void init() {
        ArrayList<Pair<Integer, Integer>> lhs = this.parent.lhs();
        Pair<Integer, Integer> cods = this.parent.codons();
        ArrayList<Integer> ps = new ArrayList<Integer>();
        if (this.isForward()) {
            int ind = 0;
            for (Pair<Integer, Integer> p : lhs) {
                int l = (Integer)p.a();
                int h = (Integer)p.b();
                for (int i = l; i <= h; ++i) {
                    this.pos2loc.put(ind, i);
                    if (i == (Integer)cods.a() || i == (Integer)cods.b()) {
                        ps.add(ind);
                    }
                    ++ind;
                }
            }
        } else {
            int ind = 0;
            for (int j = lhs.size() - 1; j >= 0; --j) {
                int h;
                Pair<Integer, Integer> p = lhs.get(j);
                int l = (Integer)p.a();
                for (int i = h = ((Integer)p.b()).intValue(); i >= l; --i) {
                    this.pos2loc.put(ind, i);
                    if (i == (Integer)cods.a() || i == (Integer)cods.b()) {
                        ps.add(ind);
                    }
                    ++ind;
                }
            }
        }
        this.cinds = new Pair(ps.get(0), ps.get(1));
        this.uid = this.geneID() + "_" + this.parent.ID() + "_" + this.sas;
    }

    public void setParent(Isoform par) {
        this.parent = par;
    }

    public Isoform parent() {
        return this.parent;
    }

    public String geneID() {
        return this.parent.geneID();
    }

    public String transcriptID() {
        return this.parent.ID();
    }

    public String uniqueID() {
        return this.uid;
    }

    public String chr() {
        return this.parent.chr();
    }

    public String sequence() {
        return this.seq;
    }

    public char strand() {
        return this.parent.strand();
    }

    public char sas() {
        return this.sas;
    }

    public int location(int pos) {
        return this.pos2loc.get(pos);
    }

    public String toString() {
        return this.uniqueID() + "_" + this.strand();
    }

    public HashMap<Integer, Integer> pos2loc() {
        return this.pos2loc;
    }

    public Pair<Integer, Integer> codingInds() {
        return this.cinds;
    }

    public boolean isForward() {
        if (this.strand() == '+') {
            return this.sas == 's';
        }
        return this.sas == 'a';
    }

    public static boolean isPair(IsoformStrand ia, IsoformStrand ib) {
        return ia.geneID().equals(ib.geneID()) && ia.transcriptID().equals(ib.transcriptID()) && ia.sas() != ib.sas();
    }
}

