/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.ele;

import fork.lib.base.collection.Pair;
import java.util.ArrayList;

public class TranscriptFragmentSet {
    private ArrayList<Pair<Integer, Integer>> lhs;
    private String seq;
    private String trid;
    private Pair<Integer, Integer> codons;

    public TranscriptFragmentSet(String trid, ArrayList<Pair<Integer, Integer>> lhs, Pair<Integer, Integer> codons, String seq) throws Exception {
        this.trid = trid;
        this.lhs = lhs;
        this.codons = codons;
        this.seq = seq;
        this.init();
    }

    protected void init() throws Exception {
        int len = 0;
        for (Pair<Integer, Integer> p : this.lhs) {
            len += (Integer)p.b() - (Integer)p.a() + 1;
        }
        if (len != this.seq.length()) {
            System.err.println("len not match: len=" + len + " seq=" + this.seq.length());
            throw new Exception();
        }
    }

    public Pair<Integer, Integer> getLowHigh() {
        int l = Integer.MAX_VALUE;
        int h = Integer.MIN_VALUE;
        for (Pair<Integer, Integer> vs : this.lhs) {
            l = Math.min(l, (Integer)vs.a());
            l = Math.min(l, (Integer)vs.b());
            h = Math.max(h, (Integer)vs.a());
            h = Math.max(h, (Integer)vs.b());
        }
        return new Pair((Object)l, (Object)h);
    }

    public ArrayList<Pair<Integer, Integer>> lowHighs() {
        return this.lhs;
    }

    public Pair<Integer, Integer> codons() {
        return this.codons;
    }

    public String sequence() {
        return this.seq;
    }

    public String transcriptID() {
        return this.trid;
    }
}

