/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.hot;

import fork.lib.base.collection.Pair;
import fork.lib.base.format.collection.ArrayOp1D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import prog.core.Param;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadShrink;
import prog.core.aln.read.Seed;
import prog.core.index.Index;

public class Anchor
implements Serializable {
    public int lind = -1;
    public int rind = -1;
    public int firstSize = 0;
    public int lastSize = 0;
    public String ins = "";

    public Anchor() {
    }

    public Anchor(ArrayList<Pair<Seed, ArrayList<Integer>>> locs, Index index, String isostr, Read read, Param par) {
        this(locs, locs, index, isostr, isostr, read, par);
    }

    public Anchor(ArrayList<Pair<Seed, ArrayList<Integer>>> locsa, ArrayList<Pair<Seed, ArrayList<Integer>>> locsb, Index index, String isoastr, String isobstr, Read read, Param par) {
        IsoformStrand isoa = index.getIsoformStrand(isoastr);
        IsoformStrand isob = index.getIsoformStrand(isobstr);
        if (locsa.size() < 2 || locsb.size() < 2) {
            return;
        }
        if (this.hasFirst(locsa, read) && this.hasLast(locsb, read)) {
            ArrayList<Pair<Seed, Integer>> clusf = this.cluster(locsa, 0, index);
            if (clusf == null) {
                return;
            }
            ArrayList<Pair<Seed, Integer>> clusl = this.cluster(locsb, locsb.size() - 1, index);
            if (clusl == null) {
                return;
            }
            this.firstSize = clusf.size();
            this.lastSize = clusl.size();
            ReadShrink rsh = new ReadShrink(isoa.sequence().substring((Integer)clusf.get(clusf.size() - 1).b()), read.sequence().substring(((Seed)clusf.get(clusf.size() - 1).a()).index()));
            rsh.computeLeft();
            int posa = ((Seed)clusf.get(clusf.size() - 1).a()).index() + rsh.left().length();
            this.rind = (Integer)clusf.get(clusf.size() - 1).b() + rsh.left().length();
            ReadShrink rsl = new ReadShrink(isob.sequence().substring(0, (Integer)clusl.get(0).b()), read.sequence().substring(0, ((Seed)clusl.get(0).a()).index()));
            rsl.computeRight();
            int posb = ((Seed)clusl.get(0).a()).index() - 1 - rsl.right().length();
            this.lind = (Integer)clusl.get(0).b() - 1 - rsl.right().length();
            if (posa <= posb + 1) {
                this.ins = read.sequence().substring(posa, posb + 1);
            } else {
                int shift = posa - posb - 1;
                if (isoa.isForward()) {
                    this.rind -= shift;
                } else {
                    this.lind += shift;
                }
                if (!isoa.uniqueID().equals(isob.uniqueID()) && isoa.sas() == 'a') {
                    this.lind += shift;
                    this.rind += shift;
                }
            }
        }
    }

    private boolean hasFirst(ArrayList<Pair<Seed, ArrayList<Integer>>> locs, Read read) {
        return ((Seed)locs.get(0).a()).index() == 0;
    }

    private boolean hasLast(ArrayList<Pair<Seed, ArrayList<Integer>>> locs, Read read) {
        return ((Seed)locs.get(locs.size() - 1).a()).index() == read.seeds().get(read.seeds().size() - 1).index();
    }

    private ArrayList<Pair<Seed, Integer>> cluster(ArrayList<Pair<Seed, ArrayList<Integer>>> locs, int ind, Index index) {
        ArrayList pss = new ArrayList();
        for (Integer loc : (ArrayList)locs.get(ind).b()) {
            ArrayList<Pair> ps = new ArrayList<Pair>();
            ps.add(new Pair(locs.get(ind).a(), (Object)loc));
            pss.add(ps);
        }
        ExtendCluster ea = new ExtendCluster((ArrayList)locs, pss, ind + 1, index, 0, locs.size() - 2){

            @Override
            protected int nextInd(int i) {
                return i + 1;
            }

            @Override
            protected int target(ArrayList<Pair<Seed, Integer>> ps) {
                return ps.size() - 1;
            }

            @Override
            protected boolean isAdjacent(int loc, int loc_) {
                return loc_ == loc + this.index.kmer();
            }

            @Override
            protected void add(ArrayList<Pair<Seed, Integer>> ps, Pair<Seed, Integer> p) {
                ps.add(p);
            }
        };
        ExtendCluster eb = new ExtendCluster((ArrayList)locs, pss, ind - 1, index, 1, locs.size() - 1){

            @Override
            protected int nextInd(int i) {
                return i - 1;
            }

            @Override
            protected int target(ArrayList<Pair<Seed, Integer>> ps) {
                return 0;
            }

            @Override
            protected boolean isAdjacent(int loc, int loc_) {
                return loc_ == loc - this.index.kmer();
            }

            @Override
            protected void add(ArrayList<Pair<Seed, Integer>> ps, Pair<Seed, Integer> p) {
                ps.add(0, p);
            }
        };
        ArrayList<Pair> val = new ArrayList<Pair>();
        for (ArrayList arrayList : pss) {
            if (arrayList.size() < 1) continue;
            val.add(new Pair((Object)arrayList, (Object)arrayList.size()));
        }
        if (val.isEmpty()) {
            return null;
        }
        Collections.sort(val, new Comparator<Pair<ArrayList<Pair<Seed, Integer>>, Integer>>(){

            @Override
            public int compare(Pair<ArrayList<Pair<Seed, Integer>>, Integer> o1, Pair<ArrayList<Pair<Seed, Integer>>, Integer> o2) {
                return Integer.compare((Integer)o2.b(), (Integer)o1.b());
            }
        });
        return (ArrayList)((Pair)val.get(0)).a();
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }

    public abstract class ExtendCluster {
        private ArrayList<Pair<Seed, ArrayList<Integer>>> locs;
        protected Index index;
        public ArrayList<ArrayList<Pair<Seed, Integer>>> pss;

        public ExtendCluster(ArrayList<Pair<Seed, ArrayList<Integer>>> locs, ArrayList<ArrayList<Pair<Seed, Integer>>> pss, int ind, Index index, int indmin, int indmax) {
            this.locs = locs;
            this.pss = pss;
            this.index = index;
            int ind_ = ind;
            ArrayList ifcont = ArrayOp1D.repeat((Object)true, (int)pss.size());
            while (ind_ >= indmin && ind_ <= indmax) {
                Pair<Seed, ArrayList<Integer>> pair = locs.get(ind_);
                for (int i = 0; i < pss.size(); ++i) {
                    if (!((Boolean)ifcont.get(i)).booleanValue()) continue;
                    boolean hasadj = false;
                    for (Integer loc_ : (ArrayList)pair.b()) {
                        ArrayList<Pair<Seed, Integer>> ps = pss.get(i);
                        int loc = (Integer)ps.get(this.target(ps)).b();
                        if (!this.isAdjacent(loc, loc_)) continue;
                        this.add(ps, (Pair<Seed, Integer>)new Pair(pair.a(), (Object)loc_));
                        hasadj = true;
                    }
                    if (hasadj) continue;
                    ifcont.set(i, false);
                }
                boolean ifbreak = true;
                for (Boolean cont : ifcont) {
                    if (!cont.booleanValue()) continue;
                    ifbreak = false;
                    break;
                }
                if (ifbreak) break;
                ind_ = this.nextInd(ind_);
            }
        }

        protected abstract int nextInd(int var1);

        protected abstract int target(ArrayList<Pair<Seed, Integer>> var1);

        protected abstract boolean isAdjacent(int var1, int var2);

        protected abstract void add(ArrayList<Pair<Seed, Integer>> var1, Pair<Seed, Integer> var2);
    }
}

