/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.hot;

import fork.lib.base.collection.Pair;
import fork.lib.base.collection.Triplet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import prog.core.Param;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.Anchor;
import prog.core.aln.hot.Detector;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotFusionRead;
import prog.core.aln.read.BufferedReadPool;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.aln.res.oncofilt.FilterExcludeRealign;
import prog.core.index.Index;

public class DetectorFusion
extends Detector {
    private HashMap<Pair<String, String>, HashMap<Pair<Integer, Integer>, HashSet<Read>>> ginds = new HashMap();
    private FilterExcludeRealign filt = new FilterExcludeRealign();

    public DetectorFusion(AlignmentResult alnres, Index index, ReadPool pool, Param par) {
        super(alnres, index, pool, par);
        HashMap<Object, Pair> ra = new HashMap<Object, Pair>();
        for (Pair gid : alnres.alignmentResultFusionRead().keySet()) {
            for (Pair iso : ((HashMap)alnres.alignmentResultFusionRead().get(gid)).keySet()) {
                for (Pair p : (ArrayList)((HashMap)alnres.alignmentResultFusionRead().get(gid)).get(iso)) {
                    ra.put(p.a(), new Pair(p.b(), (Object)iso));
                }
            }
        }
        BufferedReadPool bp = pool.bufferedPool(ra.keySet());
        for (Read r : bp) {
            Pair aso = (Pair)ra.get(r.intID());
            this.addRead((Pair<String, String>)((Pair)aso.b()), r, (Anchor)aso.a());
        }
    }

    public void addRead(Pair<String, String> isos, Read read, Anchor an) {
        HashMap<Pair<Integer, Integer>, HashSet<Read>> map;
        Pair inds;
        Pair corp;
        if (!an.ins.equals("")) {
            return;
        }
        IsoformStrand isoa = this.index.getIsoformStrand((String)isos.a());
        IsoformStrand isob = this.index.getIsoformStrand((String)isos.b());
        String ga = isoa.geneID();
        String gb = isob.geneID();
        int lind = an.rind - 1;
        int rind = an.lind + 1;
        int lloc = isoa.location(lind);
        int rloc = isob.location(rind);
        if (isoa.sas() == 's') {
            corp = new Pair((Object)ga, (Object)gb);
            inds = new Pair((Object)lloc, (Object)rloc);
        } else {
            corp = new Pair((Object)gb, (Object)ga);
            inds = new Pair((Object)rloc, (Object)lloc);
        }
        if (!this.ginds.containsKey(corp)) {
            this.ginds.put((Pair<String, String>)corp, new HashMap());
        }
        if (!(map = this.ginds.get(corp)).containsKey(inds)) {
            map.put((Pair<Integer, Integer>)inds, new HashSet());
        }
        map.get(inds).add(read);
    }

    public void start() throws Exception {
        ArrayList<Triplet> mcs = new ArrayList<Triplet>();
        for (Pair<String, String> genes : this.ginds.keySet()) {
            for (Pair<Integer, Integer> inds : this.ginds.get(genes).keySet()) {
                MutationSpotFusionRead mut = new MutationSpotFusionRead(this.index.getGene((String)genes.a()).chr(), (int)((Integer)inds.a()), this.index.getGene((String)genes.b()).chr(), (Integer)inds.b(), (String)genes.a(), (String)genes.b());
                HashSet<String> uset = new HashSet<String>();
                HashSet<Integer> rids = new HashSet<Integer>();
                for (Read r : this.ginds.get(genes).get(inds)) {
                    uset.add(r.sequence());
                    rids.add(r.intID());
                }
                mcs.add(new Triplet((Object)mut, (Object)uset.size(), rids));
            }
        }
        for (Triplet trs : mcs) {
            MutationSpotFusionRead mut = (MutationSpotFusionRead)trs.a();
            if (filterGood && !this.filt.isGood(mut, this.index) || (Integer)trs.b() < this.par.fusionFirstRunMinCount) continue;
            mut.setMutatedReads((Collection)trs.c());
            ArrayList<Integer> prsa = this.alnres.resread.getWTReadsForLocation(mut.gene1(), mut.low(), mut.low(), this.pool, this.par);
            ArrayList<Integer> prsb = this.alnres.resread.getWTReadsForLocation(mut.gene2(), mut.high(), mut.high(), this.pool, this.par);
            mut.setWTReads(prsa);
            mut.setWTReads2(prsb);
            this.res.add((MutationSpot)trs.a());
        }
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

