/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.hot;

import fork.lib.base.collection.Pair;
import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.region.GenomicRegion;
import java.util.ArrayList;
import java.util.HashSet;
import prog.core.Param;
import prog.core.aln.Alignment;
import prog.core.aln.hot.Detector;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.hot.Pileup;
import prog.core.aln.mut.MutationSpotFusionPair;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.index.Index;

public class DetectorFusionPair
extends Detector {
    protected ArrayList<Triplet<String, String, Pileup>> pus = new ArrayList();
    protected HashSet<String> wtgenes = new HashSet();
    protected Pileup puwt = new Pileup();

    public DetectorFusionPair(AlignmentResult alnres, Index index, ReadPool pool, Param par) {
        super(alnres, index, pool, par);
    }

    protected void addAlignments(String ga, String gb, Pileup pu) {
        for (Pair<Alignment, Alignment> as : this.alnres.resfpair.getAlignmentsForGeneTranslocation(ga, gb)) {
            pu.addAlignment((Alignment)as.a());
            pu.addAlignment((Alignment)as.b());
        }
        if (!this.wtgenes.contains(ga)) {
            for (Alignment aln : this.alnres.resread.getAlignmentsForGene(ga)) {
                this.puwt.addAlignment(aln);
            }
            this.wtgenes.add(ga);
        }
        if (!this.wtgenes.contains(gb)) {
            for (Alignment aln : this.alnres.resread.getAlignmentsForGene(gb)) {
                this.puwt.addAlignment(aln);
            }
            this.wtgenes.add(gb);
        }
    }

    public void start() {
        for (HashSet<String> k : this.index.correctPairs.keySet()) {
            Pileup pu = new Pileup();
            Pair<String, String> pair = this.index.correctPairs.get(k);
            String ga = (String)pair.a();
            String gb = (String)pair.b();
            this.addAlignments(ga, gb, pu);
            this.startPair(ga, gb, pu);
            this.pus.add((Triplet<String, String, Pileup>)new Triplet((Object)ga, (Object)gb, (Object)pu));
        }
    }

    private void startPair(String ga, String gb, Pileup pu) {
        Pair<Double, Double> csa = this.covs(ga, pu);
        Pair<Double, Double> csb = this.covs(gb, pu);
        if ((Double)csa.a() >= (double)this.par.fusionPEMinCount || (Double)csb.a() >= (double)this.par.fusionPEMinCount) {
            MutationSpotFusionPair mut = new MutationSpotFusionPair(this.index.getGene(ga).chr(), ga, (Double)csa.a(), (Double)csa.b(), this.index.getGene(gb).chr(), gb, (Double)csb.a(), (Double)csb.b());
            double v = mut.maxVaf();
            this.res.add(mut);
        }
    }

    private Pair<Double, Double> covs(String gid, Pileup pm) {
        GenomicRegion gene = this.index.getGene(gid).toGenomicRegion();
        ArrayList<GenomicRegion> grs = pm.coveredRegionsForGene(gene);
        double covm = Math.ceil(pm.baseCount(grs) / this.par.mostFrequencReadLength());
        double covwt = Math.ceil(this.puwt.baseCount(grs) / this.par.mostFrequencReadLength());
        return new Pair((Object)covm, (Object)covwt);
    }

    public void writeWigFiles(String odir, String tag) throws Exception {
        for (Triplet<String, String, Pileup> pdat : this.pus) {
            String ga = (String)pdat.a();
            String gb = (String)pdat.b();
            Pileup pu = (Pileup)pdat.c();
            String tag_ = tag + "_" + ga + "-" + gb;
            pu.writeToWig(odir + "/fus_" + tag_ + ".wig");
        }
        this.puwt.writeToWig(odir + "/wt_" + tag + ".wig");
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

