/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.hot;

import fork.lib.base.collection.Pair;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import prog.core.Param;
import prog.core.aln.Aligner;
import prog.core.aln.Alignment;
import prog.core.aln.hot.Detector;
import prog.core.aln.hot.DetectorFusion;
import prog.core.aln.hot.DetectorFusionPair;
import prog.core.aln.mut.AlignedElement;
import prog.core.aln.mut.Mutation;
import prog.core.aln.mut.MutationResult;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.aln.res.oncofilt.FilterExcludeRealign;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;

public class DetectorHotspot
extends Detector {
    private HashMap<MutationSpot, ArrayList<Integer>> mutrs = new HashMap();
    private FilterExcludeRealign filt = new FilterExcludeRealign();

    public DetectorHotspot(AlignmentResult alnres, Index index, ReadPool pool, Param par) throws Exception {
        super(alnres, index, pool, par);
        this.addAlignmentResult(alnres);
    }

    public void addAlignmentResult(AlignmentResult alnres) throws Exception {
        if (alnres == null) {
            return;
        }
        for (String gid : alnres.alignmentResult().keySet()) {
            HashMap<Integer, Pair> rids = new HashMap<Integer, Pair>();
            for (Alignment aln : alnres.alignmentResult().getAlignmentsForGene(gid)) {
                for (AlignedElement e : aln.elements()) {
                    if (!(e instanceof Mutation)) continue;
                    Mutation m = (Mutation)e;
                    rids.put(aln.getReadID(), new Pair((Object)m, (Object)aln));
                }
            }
            for (Read r : this.pool.bufferedPool(rids.keySet())) {
                Pair p = (Pair)rids.get(r.intID());
                Mutation m = (Mutation)p.a();
                Alignment aln = (Alignment)p.b();
                if (m.quality(r) > this.par.quality) continue;
                MutationSpot ms = m.mutationSpot(aln.isoformStrand());
                if (!this.mutrs.containsKey(ms)) {
                    this.mutrs.put(ms, new ArrayList());
                }
                this.mutrs.get(ms).add(aln.getReadID());
            }
        }
    }

    public void addMutationSpot(MutationSpot m, ArrayList<Integer> rs) {
        if (!this.mutrs.containsKey(m)) {
            this.mutrs.put(m, new ArrayList());
        }
        this.mutrs.get(m).addAll(rs);
    }

    public void start() throws Exception {
        for (MutationSpot mut : this.mutrs.keySet()) {
            if (!this.index.targetGenes.contains(mut.gene()) || filterGood && !this.filt.isGood(mut, this.index)) continue;
            ArrayList<Integer> mutreads = this.mutrs.get(mut);
            ArrayList<Integer> wtreads = this.alnres.alignmentResult().getWTReadsForLocation(mut.gene(), mut.low(), mut.high(), this.pool, this.par);
            int mutn = mutreads.size();
            int wtn = wtreads.size();
            double vaf = (double)mutn / (double)(mutn + wtn);
            if (mutn < this.par.hsFirstRunMinCount || !(vaf > this.par.hsFirstRunMinVAF)) continue;
            mut.setMutatedReads(mutreads);
            mut.setWTReads(wtreads);
            this.res.add(mut);
        }
    }

    public static void main(String[] args) throws Exception {
        String indexf = "index_pml-rara.ind";
        File root = new File("C:/muxingu/data/own/SangerSoftware2");
        File dir = new File(root + "/file");
        String tag = "PD45515a";
        if (args.length == 0) {
            args = new String[]{tag};
        } else {
            tag = args[0];
        }
        String[] infns = new String[]{dir + "/" + tag + "_1.fq.gz", dir + "/" + tag + "_2.fq.gz"};
        Index index = IndexBuilder.read(root + "/" + indexf);
        System.out.println("Index loaded. ");
        PrintWriter wr = new PrintWriter(System.out);
        Param par = new Param();
        String alnpath = dir + "/pool/align_" + tag + ".aln";
        String poolpath = dir + "/pool/pool_" + tag + ".rds";
        Aligner alner = Aligner.AlignPool(poolpath, index, par);
        System.out.println("Aligned.");
        ReadPool pool = ReadPool.read(poolpath);
        System.out.println("Pool Read.");
        AlignmentResult res2 = AlignmentResult.read(alnpath, index, pool);
        MutationResult mres = new MutationResult();
        DetectorFusion ff = new DetectorFusion(res2, index, pool, par);
        ff.start();
        mres.addAll(ff.result());
        DetectorFusionPair fp = new DetectorFusionPair(res2, index, pool, par);
        fp.start();
        mres.addAll(fp.result());
        MutationResult.writeToTxtFile(mres, index, pool, dir + "/hotspot_" + tag + ".txt", false);
        mres.write(dir + "/hotspot_" + tag + ".mut");
    }
}

