/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.hot;

import fork.lib.base.collection.Pair;
import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.Nucleotide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import prog.core.Param;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.Anchor;
import prog.core.aln.hot.Detector;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.MutationResult;
import prog.core.aln.mut.MutationSpotITD;
import prog.core.aln.mut.MutationSpotPTD;
import prog.core.aln.read.BufferedReadPool;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.index.Index;

public class DetectorITD {
    private Param par;
    private Index index;
    private ReadPool pool;
    private HashMap<String, HashMap<Triplet<Integer, Integer, String>, HashSet<Integer>>> ifc = new HashMap();
    private AlignmentResult alnres;
    private MutationResult res = new MutationResult();

    public DetectorITD(AlignmentResult alnres, Index index, ReadPool pool, Param par) {
        this.alnres = alnres;
        this.index = index;
        this.pool = pool;
        this.par = par;
        if (this.par == null) {
            this.par = new Param();
        }
        this.addAlignmentResult(alnres);
    }

    public DetectorITD(AlignmentResult alnres, Index index, ReadPool pool) {
        this(alnres, index, pool, null);
    }

    public void addRead(String isostr, Read read, Anchor an) {
        int len;
        if ((an.firstSize >= 2 && an.lastSize > 0 || an.lastSize >= 2 && an.firstSize > 0) && an.lind != -1 && an.rind != -1 && (len = an.rind - an.lind + 1) > 2 && len < this.par.maxITDLength) {
            if (!this.ifc.containsKey(isostr)) {
                this.ifc.put(isostr, new HashMap());
            }
            Triplet p = new Triplet((Object)an.lind, (Object)an.rind, (Object)an.ins);
            if (!this.ifc.get(isostr).containsKey(p)) {
                this.ifc.get(isostr).put((Triplet<Integer, Integer, String>)p, new HashSet());
            }
            this.ifc.get(isostr).get(p).add(read.intID());
        }
    }

    public void addAlignmentResult(AlignmentResult res) {
        HashMap<Object, Pair> ra = new HashMap<Object, Pair>();
        for (String gid : this.alnres.alignmentResultITD().keySet()) {
            for (String iso : ((HashMap)this.alnres.alignmentResultITD().get(gid)).keySet()) {
                for (Pair p : (ArrayList)((HashMap)this.alnres.alignmentResultITD().get(gid)).get(iso)) {
                    ra.put(p.a(), new Pair(p.b(), (Object)iso));
                }
            }
        }
        BufferedReadPool bp = this.pool.bufferedPool(ra.keySet());
        for (Read r : bp) {
            Pair aso = (Pair)ra.get(r.intID());
            this.addRead((String)aso.b(), r, (Anchor)aso.a());
        }
    }

    public void start() throws Exception {
        ArrayList<Pair> mcs = new ArrayList<Pair>();
        HashMap<MutationSpotITD, Integer> mind = new HashMap<MutationSpotITD, Integer>();
        for (String iso : this.ifc.keySet()) {
            HashMap<Triplet<Integer, Integer, String>, HashSet<Integer>> fc = this.ifc.get(iso);
            for (Triplet<Integer, Integer, String> k : fc.keySet()) {
                HashSet<Integer> rs = fc.get(k);
                MutationSpotITD itd = this.toitd(iso, (Integer)k.a(), (Integer)k.b(), (String)k.c());
                itd.setMutatedReads(rs);
                if (itd == null) continue;
                if (!mind.containsKey(itd)) {
                    mcs.add(new Pair((Object)itd, rs));
                    mind.put(itd, mcs.size() - 1);
                    continue;
                }
                Pair pair = (Pair)mcs.get((Integer)mind.get(itd));
                ((MutationSpotITD)pair.a()).mutReads.addAll(itd.mutReads);
            }
        }
        for (Pair pair : mcs) {
            MutationSpotITD itd = (MutationSpotITD)pair.a();
            if (Detector.filterGood && !this.par.filt.isGood(itd, this.index) || ((HashSet)pair.b()).size() < this.par.itdFirstRunMinCount) continue;
            int loc = itd.junction(this.index);
            ArrayList<Integer> prs = this.alnres.alignmentResult().getWTReadsForLocation(itd.gene(), loc, loc, this.pool, this.par);
            itd.setWTReads(prs);
            this.res.add(itd);
        }
    }

    private MutationSpotITD toitd(String istr, int low, int high, String ins) {
        String seqins;
        IsoformStrand iso = this.index.getIsoformStrand(istr);
        int l = low + 1;
        String seq = iso.sequence().substring(l, high);
        String string = seqins = iso.sas() == 's' ? ins + iso.sequence().substring(l, high) : iso.sequence().substring(l, high) + Nucleotide.reverseComplement((String)ins);
        if (seq.isEmpty()) {
            return null;
        }
        if (iso.isForward()) {
            return iso.geneID().equals("KMT2A") ? new MutationSpotPTD(iso.chr(), iso.location(l), iso.location(l + seq.length() - 1), seqins, iso.geneID()) : new MutationSpotITD(iso.chr(), iso.location(l), iso.location(l + seq.length() - 1), seqins, iso.geneID());
        }
        return iso.geneID().equals("KMT2A") ? new MutationSpotPTD(iso.chr(), iso.location(l + seq.length() - 1), iso.location(l), Nucleotide.reverseComplement((String)seqins), iso.geneID()) : new MutationSpotITD(iso.chr(), iso.location(l + seq.length() - 1), iso.location(l), Nucleotide.reverseComplement((String)seqins), iso.geneID());
    }

    public MutationResult result() {
        return this.res;
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

