/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.hot;

import fork.lib.base.collection.Pair;
import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.Nucleotide;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import prog.core.Param;
import prog.core.aln.Alignment;
import prog.core.aln.ReadAligner;
import prog.core.aln.ele.Gene;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.ele.TranscriptFragmentSet;
import prog.core.aln.hot.Anchor;
import prog.core.aln.mut.AlignedElement;
import prog.core.aln.mut.Insertion;
import prog.core.aln.mut.Mutation;
import prog.core.aln.mut.MutationResult;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotDeletion;
import prog.core.aln.mut.MutationSpotFusionPair;
import prog.core.aln.mut.MutationSpotFusionRead;
import prog.core.aln.mut.MutationSpotITD;
import prog.core.aln.mut.MutationSpotInsertion;
import prog.core.aln.mut.MutationSpotSubstitution;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.aln.res.oncofilt.PathogenicityFilter;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;

public class VafCorrector {
    private static String GENE_WT = "wt";
    private static String GENE_MUT = "mut";
    private MutationSpot mut;
    private ArrayList<Triplet<String, Region, String>> spss;
    private ArrayList<Triplet<Index, Region, Index>> inds = new ArrayList();
    private Param par;
    private MutationResult mutres = new MutationResult();

    public VafCorrector(MutationSpot mut, ArrayList<Triplet<String, Region, String>> spss, Param par) throws Exception {
        this.mut = mut;
        this.spss = spss;
        this.par = par;
        this.init();
    }

    public MutationResult mutationResult() {
        return this.mutres;
    }

    protected void init() throws Exception {
        this.par.ifAlignEnds = true;
    }

    public void correct(AlignmentResult res, Index index, ReadPool pool) throws Exception {
        IsoformStrand iso = this.mut.isoformStrandSense(index);
        String gid = iso.geneID();
        if (this.mut instanceof MutationSpotSubstitution || this.mut instanceof MutationSpotInsertion || this.mut instanceof MutationSpotDeletion) {
            int mhs;
            for (Read read : this.mut.wtReads(pool)) {
                int rid = read.intID();
                RealignmentClassifier re = new RealignmentClassifier(read, this.inds);
                if (re.ifwt) {
                    if (re.ifmut) {
                        this.mut.mutReads.remove(rid);
                        continue;
                    }
                    this.mut.wtReads.add(rid);
                    this.mut.mutReads.remove(rid);
                    continue;
                }
                if (re.ifmut) {
                    this.mut.mutReads.add(rid);
                    this.mut.wtReads.remove(rid);
                    continue;
                }
                this.mut.wtReads.remove(rid);
            }
            int minc = this.par.hsSecondRunMinCountGene.containsKey(this.mut.gene()) ? this.par.hsSecondRunMinCountGene.get(this.mut.gene()) : this.par.hsSecondRunMinCount;
            int n = mhs = this.par.hsUniqueSeqMinCountGene.containsKey(this.mut.gene()) ? this.par.hsUniqueSeqMinCountGene.get(this.mut.gene()) : this.par.hsUniqueSeqMinCount;
            if (this.mut.mutReads.size() >= minc && this.mut.vaf() > this.par.hsSecondRunMinVAF && this.uniqueSeqs(this.mut.mutatedReads(pool)) >= mhs) {
                this.mutres.add(this.mut);
            }
        } else if (this.mut instanceof MutationSpotITD) {
            int minc;
            HashSet<Read> rers = new HashSet<Read>();
            HashSet<Read> wtrs = this.mut.wtReads(pool);
            rers.addAll(wtrs);
            HashSet<Integer> rerids = new HashSet<Integer>();
            for (Pair<Integer, Anchor> p : res.alignmentResultITD().getAlignmentsForGeneITD(gid)) {
                rerids.add((Integer)p.a());
            }
            for (Read r : pool.bufferedPool(rerids)) {
                rers.add(r);
            }
            for (Read read : rers) {
                int rid = read.intID();
                RealignmentClassifier re = new RealignmentClassifier(read, this.inds);
                if (wtrs.contains(read)) {
                    if (!re.ifmut || re.ifwt) continue;
                    this.mut.mutReads.add(rid);
                    this.mut.wtReads.remove(rid);
                    continue;
                }
                if (!re.ifmut || re.ifwt) continue;
                this.mut.mutReads.add(rid);
            }
            int n = minc = this.par.itdSecondRunMinCountGene.containsKey(this.mut.gene()) ? this.par.itdSecondRunMinCountGene.get(this.mut.gene()) : this.par.itdSecondRunMinCount;
            if (this.mut.mutReads.size() >= minc && this.mut.vaf() > this.par.itdSecondRunMinVAF && this.uniqueSeqs(this.mut.mutatedReads(pool)) >= this.par.itdUniqueSeqMinCount) {
                this.mutres.add(this.mut);
            }
        } else if (this.mut instanceof MutationSpotFusionRead) {
            MutationSpotFusionRead mutf = (MutationSpotFusionRead)this.mut;
            HashSet<Read> rers = new HashSet<Read>();
            HashSet<Integer> rerids = new HashSet<Integer>();
            for (Pair<Integer, Anchor> pair : res.alignmentResultFusionRead().getReadForGeneTranslocation(mutf.gene1(), mutf.gene2())) {
                rerids.add((Integer)pair.a());
            }
            for (Read r : pool.bufferedPool(rerids)) {
                rers.add(r);
            }
            for (Read read : rers) {
                if (this.mut.mutReads.contains(read.intID())) continue;
                int rid = read.intID();
                RealignmentClassifier re = new RealignmentClassifier(read, this.inds);
                if (!re.ifmut || re.ifwt) continue;
                this.mut.mutReads.add(rid);
            }
            if (this.mut.mutReads.size() >= this.par.fusionSecondRunMinCount) {
                this.mutres.add(this.mut);
            }
        } else if (this.mut instanceof MutationSpotFusionPair) {
            this.mutres.add(this.mut);
        }
    }

    private int uniqueSeqs(HashSet<Read> rs) {
        HashSet<String> set = new HashSet<String>();
        for (Read r : rs) {
            String s = r.sequence();
            String sr = Nucleotide.reverseComplement((String)s);
            if (set.contains(s) || set.contains(sr)) continue;
            set.add(s);
        }
        return set.size();
    }

    public void build() throws Exception {
        if (this.mut instanceof MutationSpotFusionPair) {
            return;
        }
        for (Triplet<String, Region, String> sps : this.spss) {
            this.inds.add((Triplet<Index, Region, Index>)new Triplet((Object)this.buildIndex((String)sps.a(), GENE_MUT), sps.b(), (Object)this.buildIndex((String)sps.c(), GENE_WT)));
        }
    }

    private Index buildIndex(String seq, String tag) throws Exception {
        Index ret = new Index(this.par.kmer);
        Gene gene = new Gene(GENE_WT, "c", '+');
        ArrayList<Pair<Integer, Integer>> lhs = new ArrayList<Pair<Integer, Integer>>();
        lhs.add(new Pair((Object)0, (Object)(seq.length() - 1)));
        gene.addTranscript(new TranscriptFragmentSet(tag, lhs, (Pair<Integer, Integer>)new Pair((Object)0, (Object)(seq.length() - 1)), seq));
        ret.addGene(gene);
        return ret;
    }

    private static boolean coversMutLoc(AlignedElement e, Region taregstr) throws Exception {
        Region mutreg;
        if (e instanceof Insertion) {
            Insertion ins = (Insertion)e;
            mutreg = new Region(ins.location(), ins.location() + ins.insertion().length() - 1);
        } else {
            mutreg = e.referenceRegion();
        }
        return mutreg.overlapsWith(taregstr);
    }

    private static Region targetRegionStranded(IsoformStrand iso, Region tareg) throws Exception {
        Region ret = iso.isForward() ? tareg : new Region((double)(iso.sequence().length() - 1) - tareg.high(), (double)(iso.sequence().length() - 1) - tareg.low());
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String[] stringArray;
        File root = new File("C:/muxingu/data/own/SangerSoftware2");
        String dir = "C:\\muxingu\\data\\own\\SangerSoftware2\\file";
        String tt = "TCGA-AB-2872";
        if (args.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tt;
        } else {
            stringArray = args;
        }
        args = stringArray;
        String tag = args[0];
        Param par = new Param();
        String aln = dir + "/pool/align_" + tag + ".aln";
        String poolpath = dir + "/pool/pool_" + tag + ".rds";
        Index index = IndexBuilder.read(root + "/index_AML-33genes.ind");
        System.out.println("Index loaded. ");
        ReadPool pool = ReadPool.read(poolpath);
        AlignmentResult res = AlignmentResult.read(aln, index, pool);
        MutationResult allmuts = MutationResult.read(dir + "/hotspot_" + tag + ".mut");
        MutationResult mutout = new MutationResult();
        for (MutationSpot mut : allmuts.allMutations()) {
            VafCorrector cor = new VafCorrector(mut, mut.reconstructedTranscripts(index, par.mostFrequencReadLength()), par);
            cor.build();
            cor.correct(res, index, pool);
            mutout.addAll(cor.mutationResult());
        }
        mutout.labelMutations(new PathogenicityFilter(root + "/oncogenicity_filter_shiozawa.txt"), index);
        MutationResult.writeToTxtFile(mutout, index, pool, dir + "/hotspot_" + tag + "_corrected.txt", false);
        mutout.write(dir + "/hotspot_" + tag + "_corrected.mut");
        MutationResult respatho = mutout.filterSubset();
        MutationResult.writeToTxtFile(respatho, index, pool, dir + "/hotspot_" + tag + "_onco.txt", false);
    }

    class RealignmentClassifier {
        public boolean ifwt = false;
        public boolean ifmut = false;
        public Realigner wtaln;
        public Realigner mutaln;

        public RealignmentClassifier(Read read, ArrayList<Triplet<Index, Region, Index>> inds) throws Exception {
            for (Triplet<Index, Region, Index> iri : inds) {
                this.wtaln = new Realigner((Index)iri.c(), (Region)iri.b(), read, VafCorrector.this.par);
                this.mutaln = new Realigner((Index)iri.a(), (Region)iri.b(), read, VafCorrector.this.par);
                this.ifwt = this.wtaln.ifalign && this.wtaln.ifspan && !this.wtaln.ifmutcover;
                this.ifmut = this.mutaln.ifalign && this.mutaln.ifspan && !this.mutaln.ifmutcover;
            }
        }
    }

    class Realigner {
        public int mismatch = -1;
        public boolean ifalign = false;
        public boolean ifmutcover = false;
        public boolean ifspan;
        public Alignment aln;

        public Realigner(Index index, Region reg, Read read, Param par) throws Exception {
            Alignment aln_ = new ReadAligner(read, index, par).bestAlignment();
            if (aln_ == null) {
                return;
            }
            this.mismatch = aln_.mutationBases();
            if (this.mismatch > par.realignMaxMismatch) {
                return;
            }
            IsoformStrand iso = aln_.isoformStrand();
            Region taregstd = VafCorrector.targetRegionStranded(iso, reg);
            Region span = aln_.span();
            if (span.overlapsWith(taregstd)) {
                this.ifspan = true;
            }
            for (AlignedElement e : aln_.elements()) {
                if (!(e instanceof Mutation) || !VafCorrector.coversMutLoc(e, taregstd)) continue;
                this.ifmutcover = true;
            }
            this.ifalign = true;
            this.aln = aln_;
        }
    }
}

