/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.bio.seq.Nucleotide;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.mut.Mutation;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotDeletion;
import prog.core.aln.read.Read;

public class Deletion
extends Mutation {
    public Deletion(int l, int h) {
        try {
            this.refreg = new Region(l, h);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Deletion(double l, double h) {
        this((int)l, (int)h);
    }

    public Deletion() {
    }

    @Override
    public MutationSpot mutationSpot(IsoformStrand iso) {
        int h;
        int l;
        String dseq = iso.sequence().substring((int)this.refreg.low(), (int)this.refreg.high() + 1);
        if (iso.isForward()) {
            l = iso.location((int)this.refreg.low());
            h = iso.location((int)this.refreg.high());
        } else {
            h = iso.location((int)this.refreg.low());
            l = iso.location((int)this.refreg.high());
            dseq = Nucleotide.reverseComplement((String)dseq);
        }
        return new MutationSpotDeletion(iso.chr(), l, h, dseq, iso.geneID());
    }

    @Override
    public double quality(Read read) {
        return 0.0;
    }

    public String toString() {
        return (int)this.refreg.low() + "-" + (int)this.refreg.high() + ": Del";
    }
}

