/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.bio.seq.Nucleotide;
import fork.lib.bio.seq.parser.fastq.Phred;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.mut.Mutation;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotInsertion;
import prog.core.aln.read.Read;

public class Insertion
extends Mutation {
    private int loc;
    private String ins;

    public Insertion(int pos, int loc, String ins) {
        try {
            this.seqreg = new Region(pos, pos + ins.length() - 1);
            this.loc = loc;
            this.ins = ins;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Insertion() {
    }

    public String insertion() {
        return this.ins;
    }

    public int location() {
        return this.loc;
    }

    @Override
    public MutationSpot mutationSpot(IsoformStrand iso) {
        int loc_;
        String ins_ = null;
        if (iso.isForward()) {
            loc_ = iso.location(this.loc);
            ins_ = this.ins;
        } else {
            loc_ = iso.location(this.loc) + 1;
            ins_ = Nucleotide.reverseComplement((String)this.ins);
        }
        return new MutationSpotInsertion(iso.chr(), loc_, loc_, ins_, iso.geneID());
    }

    public String toString() {
        return (int)this.seqreg.low() + "-" + (int)this.seqreg.high() + ": Ins:" + this.ins;
    }

    @Override
    public double quality(Read read) {
        double ret = 0.0;
        for (int i = (int)this.seqreg.low(); i <= (int)this.seqreg.high(); ++i) {
            ret = Math.max(ret, (Double)Phred.PHRED33.get(Character.valueOf(read.quality().charAt(i))));
        }
        return ret;
    }
}

