/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import prog.core.Statics;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotDeletion;
import prog.core.aln.mut.MutationSpotFusion;
import prog.core.aln.mut.MutationSpotFusionPair;
import prog.core.aln.mut.MutationSpotFusionRead;
import prog.core.aln.mut.MutationSpotInsertion;
import prog.core.aln.mut.MutationSpotSubstitution;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.oncofilt.FilterArtefact;
import prog.core.aln.res.oncofilt.PathogenicityFilter;
import prog.core.index.Index;

public class MutationResult
extends HashMap<String, HashMap<String, MutationSpot>>
implements Serializable {
    private static DecimalFormat df = new DecimalFormat("0.000");
    private static DecimalFormat df1p = new DecimalFormat("#.#");
    public static boolean ifprint = false;

    public void add(MutationSpot mut) {
        String gene = mut.gene();
        if (!this.containsKey(gene)) {
            this.put(gene, new HashMap());
        }
        String mutstr = mut.toString();
        HashMap hm = (HashMap)this.get(gene);
        if (!hm.containsKey(mutstr)) {
            hm.put(mutstr, mut);
        } else {
            ((MutationSpot)hm.get((Object)mutstr)).mutReads.addAll(mut.mutReads);
        }
    }

    public void addAll(MutationResult res) {
        for (MutationSpot m : res.allMutations()) {
            this.add(m);
        }
    }

    public ArrayList<MutationSpot> allMutations() {
        ArrayList<MutationSpot> ret = new ArrayList<MutationSpot>();
        for (String gene : this.keySet()) {
            ret.addAll(this.allMutationsForGene(gene));
        }
        return ret;
    }

    public ArrayList<MutationSpot> allMutationsForGene(String gene) {
        ArrayList<MutationSpot> ms = new ArrayList<MutationSpot>();
        ms.addAll(((HashMap)this.get(gene)).values());
        Collections.sort(ms, new Comparator<MutationSpot>(){

            @Override
            public int compare(MutationSpot o1, MutationSpot o2) {
                if (o1.low() == o2.low()) {
                    return Integer.compare(o1.high(), o2.high());
                }
                return Integer.compare(o1.low(), o2.low());
            }
        });
        return ms;
    }

    public MutationResult subsetType(String ... tys) {
        MutationResult ret = new MutationResult();
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(tys));
        for (MutationSpot mut : this.allMutations()) {
            if (!set.contains(mut.type())) continue;
            ret.add(mut);
        }
        return ret;
    }

    public MutationResult filterSubset() {
        MutationResult ret = new MutationResult();
        for (MutationSpot m : this.allMutations()) {
            if (!m.label.equals(MutationSpot.LAB_ONCO)) continue;
            ret.add(m);
        }
        return ret;
    }

    public void labelMutations(PathogenicityFilter filt, Index index) {
        FilterArtefact fa = new FilterArtefact();
        for (MutationSpot m : this.allMutations()) {
            if (m instanceof MutationSpotSubstitution || m instanceof MutationSpotInsertion || m instanceof MutationSpotDeletion) {
                String aa = m.aminoAcidMutation(index);
                if (aa.contains("fs")) {
                    if (!fa.isGood(m, index)) {
                        if (filt.isExplicit(m.gene(), aa)) {
                            m.label = MutationSpot.LAB_ONCO;
                            continue;
                        }
                        m.label = MutationSpot.LAB_ARTE;
                        continue;
                    }
                    if (!filt.isGood(m.gene(), aa)) continue;
                    m.label = MutationSpot.LAB_ONCO;
                    continue;
                }
                if (filt.isGood(m.gene(), aa)) {
                    m.label = MutationSpot.LAB_ONCO;
                    continue;
                }
                m.label = MutationSpot.LAB_NEU;
                continue;
            }
            m.label = MutationSpot.LAB_ONCO;
        }
    }

    public static void writeToTxtFile(MutationResult res, Index index, ReadPool pool, String path, boolean ifseq) throws Exception {
        new File(path).getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(path));
        bw.write("Gene\tMutation\tProtMut\tMutReads\tWTReads\tVAF\tInfo\n");
        ArrayList genes = new ArrayList();
        genes.addAll(res.keySet());
        Collections.sort(genes);
        for (String gene : genes) {
            ArrayList ms = new ArrayList();
            ms.addAll(((HashMap)res.get(gene)).values());
            Collections.sort(ms, new Comparator<MutationSpot>(){

                @Override
                public int compare(MutationSpot o1, MutationSpot o2) {
                    if (o1.low() == o2.low()) {
                        return Integer.compare(o1.high(), o2.high());
                    }
                    return Integer.compare(o1.low(), o2.low());
                }
            });
            for (MutationSpot m : ms) {
                String vaf;
                String wtn;
                String mutn;
                MutationSpotFusion mf;
                String prot = m.aminoAcidMutation(index);
                if (m instanceof MutationSpotFusionRead) {
                    mf = (MutationSpotFusionRead)m;
                    mutn = Integer.toString(m.mutReads.size());
                    wtn = ((MutationSpotFusionRead)mf).wtReads.size() + "-" + ((MutationSpotFusionRead)mf).wtReads2.size();
                    vaf = "NA";
                } else if (m instanceof MutationSpotFusionPair) {
                    mf = (MutationSpotFusionPair)m;
                    mutn = ((MutationSpotFusionPair)mf).covString();
                    wtn = ((MutationSpotFusionPair)mf).covWTString();
                    vaf = "NA";
                } else {
                    mutn = Integer.toString(m.mutReads.size());
                    wtn = Integer.toString(m.wtReads.size());
                    vaf = df.format(m.vaf());
                }
                bw.write(gene + "\t" + m.toString() + "\t" + prot + "\t" + mutn + "\t" + wtn + "\t" + vaf + "\t" + m.label + "\n");
                if (ifseq && !m.type().equals("Sub")) {
                    for (Read rd : m.mutatedReads(pool)) {
                        bw.write("\t" + rd.id() + "\t" + rd.sequence() + "\n");
                    }
                }
                if (!ifprint) continue;
                for (Read rd : m.mutatedReads(pool)) {
                    bw.write("\tmut\t" + rd.id() + "\t" + rd.sequence() + "\n");
                }
                for (Read rd : m.wtReads(pool)) {
                    bw.write("\twt\t" + rd.id() + "\t" + rd.sequence() + "\n");
                }
            }
        }
        bw.close();
    }

    public void write(String path) throws Exception {
        Output out = new Output((OutputStream)new GZIPOutputStream(new FileOutputStream(path)));
        Statics.kryo.writeClassAndObject(out, (Object)this);
        out.close();
    }

    public static MutationResult read(String path) throws Exception {
        Input in = new Input((InputStream)new GZIPInputStream(new FileInputStream(path)));
        MutationResult ret = (MutationResult)Statics.kryo.readClassAndObject(in);
        in.close();
        return ret;
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

