/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.Nucleotide;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;
import prog.core.aln.read.ReadShrink;
import prog.core.index.Index;

public abstract class MutationSpot
implements Serializable {
    public static String LAB_ONCO = "Oncogenic";
    public static String LAB_ARTE = "Sequencing_artefact";
    public static String LAB_NEU = "Neutral";
    protected String chr;
    protected String type;
    protected String mut;
    protected String gene;
    protected int low;
    protected int high;
    public String label = "-";
    protected transient String mutseq = null;
    public HashSet<Integer> mutReads = new HashSet();
    public HashSet<Integer> wtReads = new HashSet();

    public MutationSpot(String chr, int low, int high, String type, String mut, String gene) {
        this.chr = chr;
        this.type = type;
        this.mut = mut;
        this.gene = gene;
        this.low = low;
        this.high = high;
    }

    public MutationSpot() {
    }

    public abstract String toString();

    public abstract String mutatedCDS(Index var1);

    public abstract String aminoAcidMutation(Index var1);

    public abstract ArrayList<Triplet<String, Region, String>> reconstructedTranscripts(Index var1, int var2) throws Exception;

    public String gene() {
        return this.gene;
    }

    public String chr() {
        return this.chr;
    }

    public int low() {
        return this.low;
    }

    public int high() {
        return this.high;
    }

    public String type() {
        return this.type;
    }

    public String mutString() {
        return this.mut;
    }

    public IsoformStrand isoformStrandSense(Index index) {
        return index.getGene(this.gene).isoforms().get(0).strandSense();
    }

    public void setGene(String gene) {
        this.gene = gene;
    }

    public void setWTReads(Collection<Integer> bg) {
        this.wtReads = new HashSet();
        this.wtReads.addAll(bg);
    }

    public void setMutatedReads(Collection<Integer> rs) {
        this.mutReads = new HashSet();
        this.mutReads.addAll(rs);
    }

    public double vaf() {
        int mn = this.mutReads.size();
        int bg = this.wtReads.size();
        double tot = bg + mn;
        return tot == 0.0 ? 0.0 : (double)mn / tot;
    }

    public HashSet<Read> mutatedReads(ReadPool p) {
        HashSet<Read> ret = new HashSet<Read>();
        for (Read rd : p.bufferedPool(this.mutReads)) {
            ret.add(rd);
        }
        return ret;
    }

    public HashSet<Read> wtReads(ReadPool p) {
        HashSet<Read> ret = new HashSet<Read>();
        for (Read rd : p.bufferedPool(this.wtReads)) {
            ret.add(rd);
        }
        return ret;
    }

    public String wtCDS(Index index) {
        IsoformStrand iso = this.isoformStrandSense(index);
        return iso.sequence().substring((Integer)iso.codingInds().a(), (Integer)iso.codingInds().b() + 1);
    }

    public static int mutposlow(IsoformStrand iso, MutationSpot mut) {
        return iso.isForward() ? MutationSpot.mutpos(iso, mut.low()) : MutationSpot.mutpos(iso, mut.high());
    }

    public static int mutposhigh(IsoformStrand iso, MutationSpot mut) {
        return iso.isForward() ? MutationSpot.mutpos(iso, mut.high()) : MutationSpot.mutpos(iso, mut.low());
    }

    protected static int mutpos(IsoformStrand iso, int ref) {
        int pos;
        String seq = iso.sequence();
        if (iso.isForward()) {
            for (pos = 0; pos < seq.length() && iso.pos2loc().get(pos) < ref; ++pos) {
            }
        } else {
            while (pos < seq.length() && iso.pos2loc().get(pos) > ref) {
                ++pos;
            }
        }
        return pos;
    }

    protected static char subchar(IsoformStrand iso, MutationSpot m) {
        return iso.isForward() ? m.mutString().split(">")[1].charAt(0) : Nucleotide.complementaryNucleotide((char)m.mutString().split(">")[1].charAt(0));
    }

    protected static String aaMutDiffLen(String mutseq, String wtseq, String muta, String wta, String tag, int off) {
        if (MutationSpot.isInFrame(mutseq, wtseq)) {
            ReadShrink rs = new ReadShrink(wta, muta);
            rs.computeLeft();
            rs.computeRight();
            if (tag.equals("Ins")) {
                int ia = rs.left().length() - 1;
                int ib = ia + 1;
                if (ia < wta.length() && ib < wta.length()) {
                    return wta.charAt(ia) + "" + ia + "-" + wta.charAt(ib) + ib + "_" + tag + ":" + rs.sequenceRemain();
                }
                return wta.charAt(ia) + "" + ia + "_" + tag + ":" + rs.sequenceRemain();
            }
            if (tag.equals("Del")) {
                int ia = rs.left().length() + 1;
                int ib = rs.left().length() + 1 + rs.referenceRemain().length() - 1;
                if (ia < wta.length() && ib < wta.length()) {
                    return (ia == ib ? wta.charAt(ia) + "" + ia : wta.charAt(ia) + "" + ia + "-" + wta.charAt(ib) + "" + ib) + "_" + tag + ":" + rs.referenceRemain();
                }
                int ia_ = ia - 1;
                return wta.charAt(ia_) + "" + ia_ + "_" + tag + ":" + rs.referenceRemain();
            }
            System.err.println("Unknown type " + tag + " code error!");
            System.exit(1);
            return null;
        }
        return MutationSpot.stringFrameShift(wta, muta);
    }

    protected static boolean isInFrame(String wt, String mut) {
        int dif = Math.abs(mut.length() - wt.length());
        return (double)dif / 3.0 == (double)(dif / 3);
    }

    protected static String stringFrameShift(String wt, String mut) {
        for (int i = 0; i < Math.min(wt.length(), mut.length()); ++i) {
            if (mut.charAt(i) == wt.charAt(i)) continue;
            String app = "";
            int inslen = mut.indexOf("*", i) - i;
            if (inslen > 0) {
                app = "*" + Integer.toString(inslen);
            }
            return wt.charAt(i) + "" + (i + 1) + "fs" + app;
        }
        return "??fs";
    }

    protected static int left(int pos, int rlen, IsoformStrand iso) {
        return pos >= rlen ? pos - rlen : 0;
    }

    protected static int right(int pos, int rlen, IsoformStrand iso) {
        return pos + rlen < iso.sequence().length() ? pos + rlen : iso.sequence().length();
    }

    protected static void addtoset(String nseq, String wtseq, Region reg, ArrayList<Triplet<String, Region, String>> sps, HashSet<String> nseqset) {
        if (nseq.equals(wtseq)) {
            return;
        }
        if (!nseqset.contains(nseq)) {
            sps.add((Triplet<String, Region, String>)new Triplet((Object)nseq, (Object)reg, (Object)wtseq));
            nseqset.add(nseq);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutationSpot other = (MutationSpot)obj;
        if (!Objects.equals(this.chr, other.chr)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.mut, other.mut)) {
            return false;
        }
        if (!Objects.equals(this.low, other.low)) {
            return false;
        }
        return Objects.equals(this.high, other.high);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.chr);
        hash = 97 * hash + Objects.hashCode(this.low);
        hash = 97 * hash + Objects.hashCode(this.high);
        hash = 97 * hash + Objects.hashCode(this.type);
        hash = 97 * hash + Objects.hashCode(this.mut);
        return hash;
    }
}

