/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.CodonTranslator;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import prog.core.aln.ele.Gene;
import prog.core.aln.ele.Isoform;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.MutationSpot;
import prog.core.index.Index;

public class MutationSpotDeletion
extends MutationSpot
implements Serializable {
    public MutationSpotDeletion(String chr, int low, int high, String mut, String gene) {
        super(chr, low, high, "Del", mut, gene);
    }

    public MutationSpotDeletion() {
    }

    @Override
    public String toString() {
        return this.chr + ":" + this.low + "-" + this.high + "_" + this.type + ":" + this.mut;
    }

    @Override
    public String mutatedCDS(Index index) {
        IsoformStrand isostd = this.isoformStrandSense(index);
        int l = (Integer)isostd.codingInds().a();
        int h = (Integer)isostd.codingInds().b() + 1;
        String seq = isostd.sequence();
        int posl = MutationSpotDeletion.mutposlow(isostd, this);
        int posh = MutationSpotDeletion.mutposhigh(isostd, this);
        return (l <= posl ? seq.substring(l, posl) : "") + (posh + 1 <= h ? seq.substring(posh + 1, h) : "");
    }

    @Override
    public String aminoAcidMutation(Index index) {
        IsoformStrand iso = this.isoformStrandSense(index);
        int l = (Integer)iso.codingInds().a();
        int h = (Integer)iso.codingInds().b() + 1;
        int posl = MutationSpotDeletion.mutposlow(iso, this);
        int posh = MutationSpotDeletion.mutposhigh(iso, this);
        if (posh <= l || posl >= h) {
            return "UTR";
        }
        String wtseq = this.wtCDS(index);
        String mutseq = this.mutatedCDS(index);
        String wta = new CodonTranslator(wtseq).frame(0);
        String muta = new CodonTranslator(mutseq).frame(0);
        return MutationSpotDeletion.aaMutDiffLen(mutseq, wtseq, muta, wta, "Del", 0);
    }

    @Override
    public ArrayList<Triplet<String, Region, String>> reconstructedTranscripts(Index index, int rlen) throws Exception {
        HashSet<String> nseqset = new HashSet<String>();
        ArrayList<Triplet<String, Region, String>> sps = new ArrayList<Triplet<String, Region, String>>();
        Gene geneid = this.isoformStrandSense(index).parent().parent();
        ArrayList<IsoformStrand> isos = new ArrayList<IsoformStrand>();
        for (Isoform is : geneid.isoforms()) {
            isos.add(is.strandSense());
        }
        for (IsoformStrand iso : isos) {
            String seq = iso.sequence();
            int posl = MutationSpotDeletion.mutposlow(iso, this);
            int posh = MutationSpotDeletion.mutposhigh(iso, this);
            int left = MutationSpotDeletion.left(posl, rlen, iso);
            int right = MutationSpotDeletion.right(posh, rlen, iso);
            String nseq = left <= posl ? seq.substring(left, posl) : "";
            nseq = nseq + (posh + 1 <= right ? seq.substring(posh + 1, right) : "");
            String wtseq = seq.substring(left, right);
            MutationSpotDeletion.addtoset(nseq, wtseq, new Region(posl - left, posh - left), sps, nseqset);
        }
        return sps;
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

