/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.base.collection.Pair;
import fork.lib.base.collection.Triplet;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import prog.core.aln.mut.MutationSpotFusion;
import prog.core.index.Index;

public class MutationSpotFusionPair
extends MutationSpotFusion
implements Serializable {
    protected static DecimalFormat df3p = new DecimalFormat("#.##");
    public ArrayList<Pair<Integer, Integer>> reads = new ArrayList();
    protected double cova;
    protected double covb;
    protected double covwta;
    protected double covwtb;

    public MutationSpotFusionPair(String chr, String gene, double cova, double covwta, String chr2, String gene2, double covb, double covwtb) {
        super(chr, 0, 1, "Fusion", "", gene);
        this.chr2 = chr2;
        this.gene2 = gene2;
        this.cova = cova;
        this.covb = covb;
        this.covwta = covwta;
        this.covwtb = covwtb;
    }

    public MutationSpotFusionPair() {
    }

    @Override
    public String toString() {
        return this.gene + "-" + this.gene2 + "_" + this.chr + "-" + this.chr2 + "_PE";
    }

    @Override
    public String mutatedCDS(Index index) {
        return null;
    }

    @Override
    public String aminoAcidMutation(Index index) {
        return "PE";
    }

    @Override
    public ArrayList<Triplet<String, Region, String>> reconstructedTranscripts(Index index, int rlen) throws Exception {
        return null;
    }

    public void addReads(int ida, int idb) {
        this.reads.add((Pair<Integer, Integer>)new Pair((Object)ida, (Object)idb));
    }

    public double covA() {
        return this.cova;
    }

    public double covB() {
        return this.covb;
    }

    public double covwtA() {
        return this.covwta;
    }

    public double covwtB() {
        return this.covwtb;
    }

    public double vafA() {
        return this.covwta + this.cova == 0.0 ? 0.0 : this.cova / (this.covwta + this.cova);
    }

    public double vafB() {
        return this.covwtb + this.covb == 0.0 ? 0.0 : this.covb / (this.covwtb + this.covb);
    }

    public double maxVaf() {
        return Math.max(this.vafA(), this.vafB());
    }

    public String covString() {
        return Integer.toString((int)Math.ceil((this.cova + this.covb) / 2.0));
    }

    public String covWTString() {
        return Integer.toString((int)this.covwta) + "_" + Integer.toString((int)this.covwtb);
    }
}

