/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.CodonTranslator;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.VafCorrector;
import prog.core.aln.mut.MutationSpotFusion;
import prog.core.aln.read.ReadShrink;
import prog.core.index.Index;

public class MutationSpotFusionRead
extends MutationSpotFusion
implements Serializable {
    public HashSet<Integer> wtReads2 = new HashSet();

    public MutationSpotFusionRead(String chr, int low, String chr2, int high, String gene, String gene2) {
        super(chr, low, high, "Fusion", "", gene);
        this.chr2 = chr2;
        this.gene2 = gene2;
    }

    public MutationSpotFusionRead() {
    }

    public HashSet<Integer> getWTReads2() {
        return this.wtReads2;
    }

    public void setWTReads2(Collection<Integer> bg) {
        this.wtReads2 = new HashSet();
        this.wtReads2.addAll(bg);
    }

    @Override
    public String toString() {
        return this.gene + ":" + this.chr + ":" + this.low + "-" + this.gene2 + ":" + this.chr2 + ":" + this.high;
    }

    @Override
    public String mutatedCDS(Index index) {
        IsoformStrand isoa = index.getGene(this.gene).isoforms().get(0).strandSense();
        IsoformStrand isob = index.getGene(this.gene2).isoforms().get(0).strandSense();
        String seqa = isoa.sequence();
        String seqb = isob.sequence();
        int posa = MutationSpotFusionRead.mutpos(isoa, this.low);
        int posb = MutationSpotFusionRead.mutpos(isob, this.high);
        if ((Integer)isoa.codingInds().a() > posa + 1 || (Integer)isob.codingInds().b() + 1 < posb) {
            return "UTR";
        }
        String nseq = seqa.substring((Integer)isoa.codingInds().a(), posa + 1) + seqb.substring(posb, (Integer)isob.codingInds().b() + 1);
        return nseq;
    }

    @Override
    public String aminoAcidMutation(Index index) {
        IsoformStrand isoa = index.getGene(this.gene).isoforms().get(0).strandSense();
        IsoformStrand isob = index.getGene(this.gene2).isoforms().get(0).strandSense();
        String mutseq = this.mutatedCDS(index);
        String wtseqa = isoa.sequence().substring((Integer)isoa.codingInds().a(), (Integer)isoa.codingInds().b() + 1);
        String wtseqb = isob.sequence().substring((Integer)isob.codingInds().a(), (Integer)isob.codingInds().b() + 1);
        String muta = new CodonTranslator(mutseq).frame(0);
        String wtaa = new CodonTranslator(wtseqa).frame(0);
        String wtab = new CodonTranslator(wtseqb).frame(0);
        String astra = this.fusionString(muta, wtaa, wtab, isoa, isob);
        return astra;
    }

    private String fusionString(String mut, String wta, String wtb, IsoformStrand isoa, IsoformStrand isob) {
        ReadShrink sl = new ReadShrink(mut, wta);
        sl.computeLeft();
        ReadShrink sr = new ReadShrink(mut, wtb);
        sr.computeRight();
        try {
            return isoa.geneID() + "." + mut.charAt(sl.left().length() - 1) + sl.left().length() + "-" + isob.geneID() + "." + mut.charAt(mut.length() - sr.right().length()) + (wtb.length() - sr.right().length() + 1);
        }
        catch (Exception e) {
            return "Error";
        }
    }

    @Override
    public ArrayList<Triplet<String, Region, String>> reconstructedTranscripts(Index index, int rlen) throws Exception {
        HashSet<String> nseqset = new HashSet<String>();
        ArrayList<Triplet<String, Region, String>> sps = new ArrayList<Triplet<String, Region, String>>();
        IsoformStrand isoa = index.getGene(this.gene).isoforms().get(0).strandSense();
        IsoformStrand isob = index.getGene(this.gene2).isoforms().get(0).strandSense();
        String seqa = isoa.sequence();
        String seqb = isob.sequence();
        int posa = MutationSpotFusionRead.mutpos(isoa, this.low);
        int posb = MutationSpotFusionRead.mutpos(isob, this.high);
        String wtseq = seqa.substring(MutationSpotFusionRead.left(posa, rlen, isoa), MutationSpotFusionRead.right(posa, rlen, isoa)) + "XXXXXXXXXX" + seqb.substring(MutationSpotFusionRead.left(posb, rlen, isob), MutationSpotFusionRead.right(posb, rlen, isob));
        int left = MutationSpotFusionRead.left(posa, rlen, isoa);
        int right = MutationSpotFusionRead.right(posb + 1, rlen, isob);
        String nseq = seqa.substring(left, posa + 1) + seqb.substring(posb, right);
        int mutind = posa - left;
        MutationSpotFusionRead.addtoset(nseq, wtseq, new Region(mutind, mutind), sps, nseqset);
        return sps;
    }

    public static void main(String[] args) throws Exception {
        VafCorrector.main(args);
    }
}

