/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.CodonTranslator;
import fork.lib.bio.seq.Nucleotide;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import prog.core.aln.ele.Gene;
import prog.core.aln.ele.Isoform;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.MutationSpot;
import prog.core.index.Index;

public class MutationSpotITD
extends MutationSpot
implements Serializable {
    public MutationSpotITD(String chr, int low, int high, String mut, String gene) {
        super(chr, low, high, "ITD", mut, gene);
    }

    public MutationSpotITD() {
    }

    @Override
    public String toString() {
        return this.chr + ":" + this.low + "-" + this.high + "_" + this.type;
    }

    public int junction(Index index) {
        IsoformStrand iso = this.isoformStrandSense(index);
        if (iso.isForward()) {
            return this.high;
        }
        return this.low;
    }

    @Override
    public String mutatedCDS(Index index) {
        IsoformStrand isostd = this.isoformStrandSense(index);
        int l = (Integer)isostd.codingInds().a();
        int h = (Integer)isostd.codingInds().b() + 1;
        String seq = isostd.sequence();
        String mstr = isostd.isForward() ? this.mutString() : Nucleotide.reverseComplement((String)this.mutString());
        int posh = MutationSpotITD.mutposhigh(isostd, this);
        return (l <= posh + 1 ? seq.substring(l, posh + 1) : "") + mstr + (posh + 1 <= h ? seq.substring(posh + 1, h) : "");
    }

    @Override
    public String aminoAcidMutation(Index index) {
        IsoformStrand iso = this.isoformStrandSense(index);
        int l = (Integer)iso.codingInds().a();
        int h = (Integer)iso.codingInds().b() + 1;
        int posl = MutationSpotITD.mutposlow(iso, this);
        int posh = MutationSpotITD.mutposhigh(iso, this);
        if (posh <= l || posl > h) {
            return "UTR";
        }
        String wtseq = this.wtCDS(index);
        String mutseq = this.mutatedCDS(index);
        String wta = new CodonTranslator(wtseq).frame(0);
        String muta = new CodonTranslator(mutseq).frame(0);
        return MutationSpotITD.aaMutDiffLen(mutseq, wtseq, muta, wta, "Ins", 1);
    }

    @Override
    public ArrayList<Triplet<String, Region, String>> reconstructedTranscripts(Index index, int rlen) throws Exception {
        HashSet<String> nseqset = new HashSet<String>();
        ArrayList<Triplet<String, Region, String>> sps = new ArrayList<Triplet<String, Region, String>>();
        Gene geneid = this.isoformStrandSense(index).parent().parent();
        ArrayList<IsoformStrand> isos = new ArrayList<IsoformStrand>();
        for (Isoform is : geneid.isoforms()) {
            isos.add(is.strandSense());
        }
        for (IsoformStrand iso : isos) {
            String seq = iso.sequence();
            String mstr = iso.isForward() ? this.mutString() : Nucleotide.reverseComplement((String)this.mutString());
            int posl = MutationSpotITD.mutposlow(iso, this);
            int posh = MutationSpotITD.mutposhigh(iso, this);
            int hleft = MutationSpotITD.left(posh, rlen, iso);
            int hright = MutationSpotITD.right(posh, rlen, iso);
            String nseq = seq.substring(hleft, posh + 1) + (mstr.length() >= rlen ? mstr.substring(0, rlen) : mstr + seq.substring(posl, posl + rlen - mstr.length() - 1));
            String wtseq = seq.substring(hleft, hright);
            MutationSpotITD.addtoset(nseq, wtseq, new Region(posl - hleft, posh - hleft), sps, nseqset);
        }
        return sps;
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

