/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.CodonTranslator;
import fork.lib.bio.seq.Nucleotide;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import prog.core.aln.ele.Gene;
import prog.core.aln.ele.Isoform;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.VafCorrector;
import prog.core.aln.mut.MutationSpot;
import prog.core.index.Index;

public class MutationSpotInsertion
extends MutationSpot
implements Serializable {
    public MutationSpotInsertion(String chr, int low, int high, String mut, String gene) {
        super(chr, low, high, "Ins", mut, gene);
    }

    public MutationSpotInsertion() {
    }

    @Override
    public String toString() {
        return this.chr + ":" + this.low + "-" + this.high + "_" + this.type + ":" + this.mut;
    }

    @Override
    public String mutatedCDS(Index index) {
        IsoformStrand isostd = this.isoformStrandSense(index);
        int l = (Integer)isostd.codingInds().a();
        int h = (Integer)isostd.codingInds().b() + 1;
        String seq = isostd.sequence();
        int pos = MutationSpotInsertion.mutposlow(isostd, this);
        return seq.substring(l, pos) + this.mutString() + seq.substring(pos, h);
    }

    @Override
    public String aminoAcidMutation(Index index) {
        IsoformStrand iso = this.isoformStrandSense(index);
        int l = (Integer)iso.codingInds().a();
        int h = (Integer)iso.codingInds().b() + 1;
        int posl = MutationSpotInsertion.mutposlow(iso, this);
        int posh = MutationSpotInsertion.mutposhigh(iso, this);
        if (posh <= l || posl > h) {
            return "UTR";
        }
        String wtseq = this.wtCDS(index);
        String mutseq = this.mutatedCDS(index);
        String wta = new CodonTranslator(wtseq).frame(0);
        String muta = new CodonTranslator(mutseq).frame(0);
        return MutationSpotInsertion.aaMutDiffLen(mutseq, wtseq, muta, wta, "Ins", 0);
    }

    @Override
    public ArrayList<Triplet<String, Region, String>> reconstructedTranscripts(Index index, int rlen) throws Exception {
        HashSet<String> nseqset = new HashSet<String>();
        ArrayList<Triplet<String, Region, String>> sps = new ArrayList<Triplet<String, Region, String>>();
        Gene geneid = this.isoformStrandSense(index).parent().parent();
        ArrayList<IsoformStrand> isos = new ArrayList<IsoformStrand>();
        for (Isoform is : geneid.isoforms()) {
            isos.add(is.strandSense());
        }
        for (IsoformStrand iso : isos) {
            int p;
            int p2;
            String seq = iso.sequence();
            int pos = MutationSpotInsertion.mutposlow(iso, this);
            int left = MutationSpotInsertion.left(pos, rlen, iso);
            int right = MutationSpotInsertion.right(pos, rlen, iso);
            String nseql = seq.substring(left, pos);
            String nseqr = seq.substring(pos, right);
            String mstr = iso.isForward() ? this.mutString() : Nucleotide.reverseComplement((String)this.mutString());
            String nseq = nseql + mstr + nseqr;
            String wtseq = nseql + nseqr;
            int sfl = 0;
            String nseql_ = nseql + mstr;
            while ((p2 = nseql.length() - (sfl + 1)) >= 0 && nseql.charAt(p2) == nseql_.charAt(p2 + mstr.length())) {
                ++sfl;
            }
            int sfr = 0;
            String nseqr_ = mstr + nseqr;
            while ((p = sfr++) < nseqr.length() && nseqr.charAt(p) == nseqr_.charAt(p)) {
            }
            int pos_ = pos - left;
            MutationSpotInsertion.addtoset(nseq, wtseq, new Region(pos_ - sfl - 1, pos_ + this.mutString().length() - 1 + sfr + 1), sps, nseqset);
        }
        return sps;
    }

    public static void main(String[] args) throws Exception {
        VafCorrector.main(args);
    }
}

