/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.base.collection.Pair;
import fork.lib.base.format.collection.ArrayOp1D;
import fork.lib.bio.seq.CodonTranslator;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.mut.MutationSpotITD;
import prog.core.aln.read.ReadShrink;
import prog.core.index.Index;

public class MutationSpotPTD
extends MutationSpotITD
implements Serializable {
    public MutationSpotPTD(String chr, int low, int high, String mut, String gene) {
        super(chr, low, high, mut, gene);
        this.type = "PTD";
    }

    public MutationSpotPTD() {
    }

    @Override
    public String aminoAcidMutation(Index index) {
        IsoformStrand iso = this.isoformStrandSense(index);
        int l = (Integer)iso.codingInds().a();
        int h = (Integer)iso.codingInds().b() + 1;
        int posl = MutationSpotPTD.mutposlow(iso, this);
        int posh = MutationSpotPTD.mutposhigh(iso, this);
        if (posh <= l || posl > h) {
            return "UTR";
        }
        String wtseq = this.wtCDS(index);
        String mutseq = this.mutatedCDS(index);
        String wta = new CodonTranslator(wtseq).frame(0);
        String muta = new CodonTranslator(mutseq).frame(0);
        ReadShrink rs = new ReadShrink(wtseq, mutseq);
        rs.computeLeft();
        rs.computeRight();
        String rem = rs.sequenceRemain();
        int ind = -((Integer)iso.codingInds().a()).intValue();
        int low = wtseq.indexOf(rem);
        try {
            Region reg = new Region(low, low + rem.length() - 1);
            ArrayList<Pair<Integer, Integer>> lhs = iso.parent().lhs();
            if (iso.strand() == '-') {
                ArrayOp1D.invert(lhs);
            }
            ArrayList<Integer> pdexs = new ArrayList<Integer>();
            Region[] sides = new Region[2];
            for (int i = 0; i < lhs.size(); ++i) {
                Pair<Integer, Integer> lh = lhs.get(i);
                int len = (Integer)lh.b() - (Integer)lh.a() + 1;
                Region exon = new Region(ind, ind + len - 1);
                if (reg.contains(exon)) {
                    pdexs.add(i + 1);
                } else if (reg.overlapsWith(exon)) {
                    if (exon.low() < reg.low() && exon.high() >= reg.low()) {
                        sides[0] = reg.overlap(exon);
                    } else if (exon.low() <= reg.high() && exon.high() > reg.high()) {
                        sides[1] = reg.overlap(exon);
                    }
                }
                ind += len;
            }
            if (!pdexs.isEmpty()) {
                if (sides[0] == null && sides[1] == null) {
                    return "exons" + pdexs.get(0) + "-" + pdexs.get(pdexs.size() - 1);
                }
                return "Error";
            }
            return MutationSpotPTD.aaMutDiffLen(mutseq, wtseq, muta, wta, "Ins", 1);
        }
        catch (Exception e) {
            return "Error";
        }
    }
}

