/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.base.collection.Triplet;
import fork.lib.bio.seq.CodonTranslator;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import prog.core.aln.ele.Gene;
import prog.core.aln.ele.Isoform;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.hot.VafCorrector;
import prog.core.aln.mut.MutationSpot;
import prog.core.index.Index;

public class MutationSpotSubstitution
extends MutationSpot
implements Serializable {
    public MutationSpotSubstitution(String chr, int low, int high, String mut, String gene) {
        super(chr, low, high, "Sub", mut, gene);
    }

    public MutationSpotSubstitution() {
    }

    @Override
    public String toString() {
        return this.chr + ":" + this.low + "-" + this.high + "_" + this.type + ":" + this.mut;
    }

    @Override
    public String mutatedCDS(Index index) {
        IsoformStrand isostd = this.isoformStrandSense(index);
        int l = (Integer)isostd.codingInds().a();
        int h = (Integer)isostd.codingInds().b() + 1;
        String seq = isostd.sequence();
        int pos = MutationSpotSubstitution.mutposlow(isostd, this);
        return (l < pos ? seq.substring(l, pos) : "") + MutationSpotSubstitution.subchar(isostd, this) + (pos + 1 < h ? seq.substring(pos + 1, h) : "");
    }

    @Override
    public String aminoAcidMutation(Index index) {
        IsoformStrand iso = this.isoformStrandSense(index);
        int l = (Integer)iso.codingInds().a();
        int h = (Integer)iso.codingInds().b() + 1;
        int posl = MutationSpotSubstitution.mutposlow(iso, this);
        int posh = MutationSpotSubstitution.mutposhigh(iso, this);
        if (posh <= l || posl > h) {
            return "UTR";
        }
        String wtseq = this.wtCDS(index);
        String mutseq = this.mutatedCDS(index);
        String wta = new CodonTranslator(wtseq).frame(0);
        String muta = new CodonTranslator(mutseq).frame(0);
        for (int i = 0; i < muta.length(); ++i) {
            if (muta.charAt(i) == wta.charAt(i)) continue;
            return wta.charAt(i) + "" + (i + 1) + "" + muta.charAt(i);
        }
        return "Syn";
    }

    @Override
    public ArrayList<Triplet<String, Region, String>> reconstructedTranscripts(Index index, int rlen) throws Exception {
        HashSet<String> nseqset = new HashSet<String>();
        ArrayList<Triplet<String, Region, String>> sps = new ArrayList<Triplet<String, Region, String>>();
        Gene geneid = this.isoformStrandSense(index).parent().parent();
        ArrayList<IsoformStrand> isos = new ArrayList<IsoformStrand>();
        for (Isoform is : geneid.isoforms()) {
            isos.add(is.strandSense());
        }
        for (IsoformStrand iso : isos) {
            String seq = iso.sequence();
            int pos = MutationSpotSubstitution.mutposlow(iso, this);
            int left = MutationSpotSubstitution.left(pos, rlen, iso);
            int right = MutationSpotSubstitution.right(pos, rlen, iso);
            String nseq = (left <= pos ? seq.substring(left, pos) : "") + MutationSpotSubstitution.subchar(iso, this) + (pos < right ? seq.substring(pos + 1, right) : "");
            String wtseq = seq.substring(left, right);
            MutationSpotSubstitution.addtoset(nseq, wtseq, new Region(pos - left, pos - left), sps, nseqset);
        }
        return sps;
    }

    public static void main(String[] args) throws Exception {
        VafCorrector.main(args);
    }
}

