/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.mut;

import fork.lib.bio.seq.Nucleotide;
import fork.lib.bio.seq.parser.fastq.Phred;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.mut.Mutation;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotSubstitution;
import prog.core.aln.read.Read;

public class Substitution
extends Mutation {
    private String seqchars;
    private String refchars;

    public Substitution(int seqpos, int refloc, String seqchars, String refchars) throws Exception {
        try {
            this.refreg = new Region(refloc, refloc + refchars.length() - 1);
            this.seqreg = new Region(seqpos, seqpos + seqchars.length() - 1);
            this.seqchars = seqchars;
            this.refchars = refchars;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (seqchars.length() != refchars.length()) {
            System.err.println("seqchar:" + this.seqchars + " != refchar:" + this.refchars);
            throw new Exception();
        }
    }

    public Substitution(int seqpos, int refloc, char seqchar, char refchar) throws Exception {
        this(seqpos, refloc, Character.toString(seqchar), Character.toString(refchar));
    }

    public Substitution() {
    }

    public String originalChars() {
        return this.refchars;
    }

    public String substitutionChars() {
        return this.seqchars;
    }

    public String toString() {
        return (int)this.seqreg.low() + "-" + (int)this.seqreg.high() + ": Sub:" + this.refchars + ">" + this.seqchars;
    }

    @Override
    public MutationSpot mutationSpot(IsoformStrand iso) {
        int h;
        int l;
        String mutstr = iso.sequence().substring((int)this.refreg.low(), (int)this.refreg.high() + 1);
        if (iso.isForward()) {
            mutstr = mutstr + ">" + this.seqchars;
            l = iso.location((int)this.refreg.low());
            h = iso.location((int)this.refreg.high());
        } else {
            mutstr = Nucleotide.reverseComplement((String)mutstr) + ">" + Nucleotide.reverseComplement((String)this.seqchars);
            h = iso.location((int)this.refreg.low());
            l = iso.location((int)this.refreg.high());
        }
        return new MutationSpotSubstitution(iso.chr(), l, h, mutstr, iso.geneID());
    }

    @Override
    public double quality(Read read) {
        double ret = 0.0;
        for (int i = (int)this.seqreg.low(); i <= (int)this.seqreg.high(); ++i) {
            ret = Math.max(ret, (Double)Phred.PHRED33.get(Character.valueOf(read.quality().charAt(i))));
        }
        return ret;
    }
}

