/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.read;

import fork.lib.bio.seq.parser.fastq.FastqEntry;
import fork.lib.bio.seq.parser.fastq.FastqReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import prog.core.Param;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.read.Read;
import prog.core.aln.read.ReadPool;

public class BufferedReadPool
implements Iterable<Read> {
    protected Param par = new Param();
    protected HashMap<String, ArrayList<Integer>> fids = new HashMap();

    public BufferedReadPool(String dir, String tag, HashMap<Integer, Integer> idf, Collection<Integer> readids) {
        this.par.ifClipEndN = false;
        for (Integer id : readids) {
            int fidind = idf.get(id);
            String path = ReadPool.tofile(dir, tag, fidind);
            if (!this.fids.containsKey(path)) {
                this.fids.put(path, new ArrayList());
            }
            this.fids.get(path).add(id);
        }
    }

    @Override
    public Iterator<Read> iterator() {
        return new Iterator<Read>(){
            int i = 0;
            int j = 0;
            String[] fs;
            HashMap<Integer, Read> cwidr;
            {
                this.fs = BufferedReadPool.this.fids.keySet().toArray(new String[BufferedReadPool.this.fids.size()]);
            }

            @Override
            public boolean hasNext() {
                if (this.fs.length == 0) {
                    return false;
                }
                if (this.j >= BufferedReadPool.this.fids.get(this.fs[this.i]).size()) {
                    this.j = 0;
                    ++this.i;
                    if (this.i > this.fs.length - 1) {
                        return false;
                    }
                    try {
                        this.loadIDR();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                return true;
            }

            @Override
            public Read next() {
                if (this.cwidr == null) {
                    try {
                        this.loadIDR();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                Read ret = this.cwidr.get(BufferedReadPool.this.fids.get(this.fs[this.i]).get(this.j));
                ++this.j;
                return ret;
            }

            private void loadIDR() throws Exception {
                FastqEntry en;
                this.cwidr = new HashMap();
                FastqReader fr = new FastqReader(this.fs[this.i], true);
                while ((en = fr.nextEntry()) != null) {
                    String[] ss = en.ID().split("\t");
                    int intid = Integer.parseInt(ss[0]);
                    this.cwidr.put(intid, new Read(intid, ss[1], en.sequence(), en.qualiy(), BufferedReadPool.this.par));
                }
                fr.close();
            }
        };
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

