/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.read;

import fork.lib.bio.seq.parser.fastq.FastqEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import prog.core.Param;
import prog.core.aln.read.ReadAbs;
import prog.core.aln.read.Seed;

public class Read
extends ReadAbs
implements Serializable {
    private int intid;
    private String id;
    private String seq;
    private String qual;
    private Param par;
    private ArrayList<Seed> seeds;
    private String overhang = "";
    private int seedlen = -1;

    public Read(int intid, String id, String seq, String qual, Param par) {
        this.intid = intid;
        this.id = id;
        this.par = par;
        this.init(seq, qual);
    }

    public Read(int intid, FastqEntry en, Param par) {
        this(intid, en.ID(), en.sequence(), en.qualiy(), par);
    }

    public Read() {
    }

    private void init(String seq, String qual) {
        if (this.par.ifClipEndN) {
            int lind;
            int rind = seq.length() - 1;
            for (lind = 0; lind < seq.length() && seq.charAt(lind) == 'N'; ++lind) {
            }
            while (rind >= 0 && seq.charAt(rind) == 'N') {
                --rind;
            }
            try {
                this.seq = seq.substring(lind, rind + 1);
                this.qual = qual.substring(lind, rind + 1);
            }
            catch (Exception e) {
                this.seq = "";
                this.qual = "";
            }
        } else {
            this.seq = seq;
            this.qual = qual;
        }
    }

    public int intID() {
        return this.intid;
    }

    public String id() {
        return this.id;
    }

    public String sequence() {
        return this.seq;
    }

    public String quality() {
        return this.qual;
    }

    public String overhang() {
        return this.overhang;
    }

    public String toString() {
        return this.seq;
    }

    public int length() {
        return this.seq.length();
    }

    public ArrayList<Seed> seeds() {
        return this.seeds;
    }

    public void initSeedSet(int k) {
        this.seeds = new ArrayList();
        int ind = 0;
        while (ind + k <= this.length()) {
            this.seeds.add(new Seed(this.seq.substring(ind, ind + k), ind));
            ind += k;
        }
        if (ind < this.length() && this.length() >= k) {
            this.overhang = this.seq.substring(this.length() - k, this.length());
        }
    }

    public void destroySeedSet() {
        this.seeds = null;
        this.overhang = null;
    }

    public void calculateLength() {
        this.seedlen = 0;
        for (Seed s : this.seeds) {
            int n = s.index() + s.sequence().length();
            if (n <= this.seedlen) continue;
            this.seedlen = n;
        }
    }

    public int seedLength() {
        if (this.seedlen == -1) {
            this.calculateLength();
        }
        return this.seedlen;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Read other = (Read)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.id);
        return hash;
    }
}

