/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.read;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import fork.lib.base.file.FileName;
import fork.lib.bio.seq.parser.fastq.FastqEntry;
import fork.lib.bio.seq.parser.fastq.FastqReader;
import fork.lib.bio.seq.parser.fastq.FastqWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import prog.core.Param;
import prog.core.Statics;
import prog.core.aln.read.BufferedReadPool;
import prog.core.aln.read.Read;

public class ReadPool
implements Iterable<Read>,
Serializable {
    protected transient FastqWriter bwc;
    protected transient String dir;
    protected Param par = new Param();
    public int nper = 20000;
    protected int ind = 0;
    protected int n = 0;
    protected String tag;
    public HashMap<Integer, Integer> idf = new HashMap();

    public ReadPool() {
    }

    public ReadPool(String dir, String tag) throws Exception {
        this.dir = dir;
        this.tag = tag;
        this.newWriter();
        this.par.ifClipEndN = false;
    }

    public ReadPool(String path) throws Exception {
        this(new File(path).getAbsoluteFile().getParent(), FileName.baseName((String)path));
    }

    private void newWriter() throws Exception {
        ++this.ind;
        if (this.bwc != null) {
            this.bwc.close();
        }
        this.bwc = new FastqWriter(ReadPool.tofile(this.dir, this.tag, this.ind), true);
    }

    public static String tofile(String dir, String tag, int ind) {
        return dir + "/" + tag + "_" + ind + ".rds";
    }

    public void write(Read read) throws Exception {
        if (this.n == this.nper) {
            this.newWriter();
            this.n = 0;
        }
        this.idf.put(read.intID(), this.ind);
        this.bwc.write(new FastqEntry(read.intID() + "\t" + read.id(), read.sequence(), "+", read.quality()));
        ++this.n;
    }

    public void close() throws Exception {
        this.bwc.close();
        this.write();
    }

    public ArrayList<String> allFiles() {
        HashSet<Integer> fns = new HashSet<Integer>();
        for (int id : this.idf.keySet()) {
            fns.add(this.idf.get(id));
        }
        ArrayList<String> ret = new ArrayList<String>();
        Iterator iterator = fns.iterator();
        while (iterator.hasNext()) {
            int fn = (Integer)iterator.next();
            ret.add(ReadPool.tofile(this.dir, this.tag, fn));
        }
        return ret;
    }

    public BufferedReadPool bufferedPool(Collection<Integer> rids) {
        return new BufferedReadPool(this.dir, this.tag, this.idf, rids);
    }

    @Override
    public Iterator<Read> iterator() {
        return new Iterator<Read>(){
            int i = 0;
            ArrayList<String> afs = ReadPool.this.allFiles();
            FastqReader fr;
            FastqEntry cwen;

            @Override
            public boolean hasNext() {
                FastqEntry en;
                if (this.i >= this.afs.size()) {
                    return false;
                }
                if (this.fr == null) {
                    try {
                        this.fr = new FastqReader(this.afs.get(this.i), true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((en = this.fr.nextEntry()) == null) {
                    try {
                        this.fr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++this.i;
                    return this.hasNext();
                }
                this.cwen = en;
                return true;
            }

            @Override
            public Read next() {
                int intid = Integer.parseInt(this.cwen.ID().split("\t")[0]);
                return new Read(intid, this.cwen, ReadPool.this.par);
            }
        };
    }

    public void write() throws Exception {
        Output out = new Output((OutputStream)new GZIPOutputStream(new FileOutputStream(this.dir + "/" + this.tag + ".rds")));
        Statics.kryo.writeClassAndObject(out, (Object)this);
        out.close();
    }

    public static ReadPool read(String path) throws Exception {
        Input in = new Input((InputStream)new GZIPInputStream(new FileInputStream(path)));
        ReadPool ret = (ReadPool)Statics.kryo.readClassAndObject(in);
        in.close();
        ret.dir = new File(path).getParentFile().getAbsolutePath();
        return ret;
    }
}

