/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.read;

public class ReadShrink {
    private String ref;
    private String seq;
    private int matleft = 0;
    private int matright = 0;

    public ReadShrink(String ref, String seq) {
        this.seq = seq;
        this.ref = ref;
    }

    public void computeLeft() {
        while (this.matleft != this.ref.length() && this.matleft != this.seq.length() && this.matleft != this.ref.length() - this.matright && this.matleft != this.seq.length() - this.matright && this.ref.charAt(this.matleft) == this.seq.charAt(this.matleft)) {
            ++this.matleft;
        }
    }

    public void computeRight() {
        while (this.matright != this.ref.length() && this.matright != this.seq.length() && this.matright != this.ref.length() - this.matleft && this.matright != this.seq.length() - this.matleft && this.ref.charAt(this.ref.length() - 1 - this.matright) == this.seq.charAt(this.seq.length() - 1 - this.matright)) {
            ++this.matright;
        }
    }

    public String left() {
        return this.seq.substring(0, this.matleft);
    }

    public String right() {
        return this.seq.substring(this.seq.length() - this.matright);
    }

    public String referenceRemain() {
        return this.ref.substring(this.matleft, this.ref.length() - this.matright);
    }

    public String sequenceRemain() {
        return this.seq.substring(this.matleft, this.seq.length() - this.matright);
    }

    public static void main(String[] args) throws Exception {
        String a = "AATTCCGG";
        String b = "AATTCCCGG";
        ReadShrink ss = new ReadShrink(a, b);
        ss.computeLeft();
        ss.computeRight();
        System.out.println(ss.left());
        System.out.println(ss.right());
    }
}

