/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.res;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import prog.core.Param;
import prog.core.aln.Alignment;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.AlignedElement;
import prog.core.aln.mut.AlignedMatch;
import prog.core.aln.read.ReadPool;
import prog.core.index.Index;

public class AlignmentResultRead
extends HashMap<String, HashMap<String, ArrayList<Alignment>>>
implements Serializable {
    public void addAlignment(Alignment aln) {
        String uid;
        HashMap map;
        if (aln == null) {
            return;
        }
        String gene = aln.isoformStrand().geneID();
        if (!this.containsKey(gene)) {
            this.put(gene, new HashMap());
        }
        if (!(map = (HashMap)this.get(gene)).containsKey(uid = aln.isoformStrand().uniqueID())) {
            map.put(uid, new ArrayList());
        }
        ((ArrayList)map.get(uid)).add(aln);
    }

    public ArrayList<Alignment> getAlignmentsForGene(String gid) {
        ArrayList<Alignment> ret = new ArrayList<Alignment>();
        if (this.containsKey(gid)) {
            for (String iso : ((HashMap)this.get(gid)).keySet()) {
                ret.addAll((Collection)((HashMap)this.get(gid)).get(iso));
            }
        }
        return ret;
    }

    public void initAlignments(Index index, ReadPool pool) {
        for (String gid : this.keySet()) {
            for (Alignment aln : this.getAlignmentsForGene(gid)) {
                aln.initTransient(index, pool);
            }
        }
    }

    public ArrayList<Integer> getWTReadsForLocation(String gid, int low, int high, ReadPool pool, Param par) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Alignment aln : this.getAlignmentsForGene(gid)) {
            for (AlignedElement ele : aln.elements()) {
                int b;
                int a;
                int mb;
                if (!(ele instanceof AlignedMatch)) continue;
                int ma = aln.isoformStrand().location((int)ele.referenceRegion().low());
                if (ma < (mb = aln.isoformStrand().location((int)ele.referenceRegion().high()))) {
                    a = ma;
                    b = mb;
                } else {
                    a = mb;
                    b = ma;
                }
                if (a > low || b < high) continue;
                int ldis = low - a;
                int rdis = b - high;
                int inda = (int)ele.sequenceRegion().low() + ldis;
                int indb = (int)ele.sequenceRegion().high() - rdis;
                ret.add(aln.getReadID());
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

