/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.res.oncofilt;

import fork.lib.bio.seq.Nucleotide;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import prog.core.aln.ele.IsoformStrand;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotInsertion;
import prog.core.index.Index;

public class FilterArtefact {
    public boolean isGood(MutationSpot mut, Index index) {
        boolean ret = true;
        if (mut instanceof MutationSpotInsertion) {
            int pancl;
            int panc;
            IsoformStrand iso = mut.isoformStrandSense(index);
            String seq = iso.sequence();
            char nt = iso.isForward() ? mut.mutString().charAt(0) : Nucleotide.complementaryNucleotide((char)mut.mutString().charAt(0));
            HashMap<Integer, Integer> pl = iso.pos2loc();
            ArrayList<Integer> ps = new ArrayList<Integer>();
            ps.addAll(pl.keySet());
            Collections.sort(ps);
            int panch = panc;
            for (pancl = panc = MutationSpot.mutposlow(iso, mut); pancl > 0; --pancl) {
                if (seq.charAt(pancl) == nt) continue;
                ++pancl;
                break;
            }
            while (panch < seq.length() - 1) {
                if (seq.charAt(panch) != nt) {
                    --panch;
                    break;
                }
                ++panch;
            }
            if (panch - pancl + 1 >= 5) {
                ret = false;
            }
        }
        return ret;
    }
}

