/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.res.oncofilt;

import java.util.Arrays;
import java.util.HashSet;
import prog.core.aln.hot.DetectorHotspot;
import prog.core.aln.mut.MutationSpot;
import prog.core.aln.mut.MutationSpotITD;
import prog.core.aln.mut.MutationSpotInsertion;
import prog.core.aln.mut.MutationSpotPTD;
import prog.core.aln.mut.MutationSpotSubstitution;
import prog.core.index.Index;

public class FilterExcludeRealign {
    public HashSet<String> exclude = new HashSet();

    public FilterExcludeRealign() {
        this.exclude.addAll(Arrays.asList("Syn", "UTR", "Error"));
    }

    public boolean isGood(MutationSpot mut, Index index) {
        boolean ret = true;
        String aty = mut.aminoAcidMutation(index);
        if (this.exclude.contains(aty)) {
            return false;
        }
        if (!(mut instanceof MutationSpotSubstitution) && !(mut instanceof MutationSpotInsertion) && mut instanceof MutationSpotITD) {
            String aa = mut.aminoAcidMutation(index);
            if (mut instanceof MutationSpotPTD) {
                ret = aa.contains("exon");
            } else if (aa.contains("Error") || aa.contains("fs") || aa.contains("UTR")) {
                ret = false;
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        DetectorHotspot.main(args);
    }
}

