/*
 * Decompiled with CFR 0.152.
 */
package prog.core.aln.res.oncofilt;

import fork.lib.base.collection.Table;
import fork.lib.base.file.io.txt.ReadTable;
import java.util.ArrayList;
import java.util.HashMap;
import prog.core.aln.res.oncofilt.Mut;
import prog.core.aln.res.oncofilt.PathFilter;
import prog.core.aln.res.oncofilt.PathFilterAAIndelRange;
import prog.core.aln.res.oncofilt.PathogenicityFilterGene;

public class PathogenicityFilter
extends HashMap<String, PathogenicityFilterGene> {
    public static String FRAMESHIFT = "frameshift";
    public static String STOP_CODON = "stopcodon";
    public static String AA_INSERT = "aainsertion";
    public static String AA_DELETE = "aadeletion";
    public String errMsg = "";
    private static PathFilter filtFS = new PathFilter(){

        @Override
        public boolean isGood(String m) {
            return m.contains("fs");
        }
    };
    private static PathFilter filtStop = new PathFilter(){

        @Override
        public boolean isGood(String m) {
            try {
                Mut mut = new Mut(m);
                return mut.mut.equals("*");
            }
            catch (Exception e) {
                return false;
            }
        }
    };

    public PathogenicityFilter(String file) {
        Table tab;
        try {
            tab = new ReadTable(file).getTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < tab.rowNumber(); ++i) {
            ArrayList row = tab.getRow(i);
            PathogenicityFilterGene fg = new PathogenicityFilterGene();
            for (String s : ((String)row.get(1)).split(",")) {
                try {
                    PathFilter f = this.filt(s);
                    fg.add(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.put(row.get(0), fg);
        }
    }

    private PathFilter filt(String m) throws Exception {
        try {
            if (m.equals(FRAMESHIFT)) {
                return filtFS;
            }
            if (m.equals(STOP_CODON)) {
                return filtStop;
            }
            if (m.contains(AA_INSERT)) {
                String[] s = m.substring(m.indexOf("[") + 1, m.indexOf("]")).split("-");
                return new PathFilterAAIndelRange("_Ins:", Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
            if (m.contains(AA_DELETE)) {
                String[] s = m.substring(m.indexOf("[") + 1, m.indexOf("]")).split("-");
                return new PathFilterAAIndelRange("_Del:", Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
            return new PathFilter(m);
        }
        catch (Exception e) {
            this.errMsg = this.errMsg + m + ", ";
            throw new Exception();
        }
    }

    public boolean isGood(String gene, String m) {
        if (this.containsKey(gene)) {
            return ((PathogenicityFilterGene)this.get(gene)).isGood(m);
        }
        return false;
    }

    public boolean isExplicit(String gene, String m) {
        String m_;
        int i = m.indexOf("*");
        String string = m_ = i != -1 ? m.substring(0, i) : m;
        if (this.containsKey(gene)) {
            for (PathFilter f : (PathogenicityFilterGene)this.get(gene)) {
                if (f.ref == null || !f.ref.toString().equals(m_)) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        String f = "C:\\muxingu\\data\\own\\SangerSoftware2/oncogenicity_filter.txt";
        PathogenicityFilter p = new PathogenicityFilter(f);
    }
}

