/*
 * Decompiled with CFR 0.152.
 */
package prog.core.index;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class FastaIndexChecker
implements Serializable {
    protected File file;

    public FastaIndexChecker(File file) throws Exception {
        this.file = file;
        this.init();
    }

    protected void init() throws Exception {
    }

    protected void initCheck() {
        ArrayList ls = null;
        ArrayList hs = null;
        String seq = "";
        if (ls.isEmpty() || hs.isEmpty()) {
            System.err.println("Empty exons!");
            System.exit(1);
        }
        if (ls.size() != hs.size()) {
            System.err.println("lows size (" + ls.size() + ") != highs size (" + hs.size() + ")");
            System.exit(1);
        }
        for (int i = 0; i < ls.size(); ++i) {
            if ((Integer)ls.get(i) <= (Integer)hs.get(i)) continue;
            System.err.println("low (" + ls.get(i) + ") > high (" + hs.get(i) + ")");
            System.exit(1);
        }
        int len = 0;
        for (int i = 0; i < ls.size(); ++i) {
            len += (Integer)hs.get(i) - (Integer)ls.get(i) + 1;
        }
        if (len != seq.toString().length()) {
            System.err.println("Sum of exon lengths(" + len + ") != Sequence length(" + seq.toString().length() + ")");
            System.exit(1);
        }
    }
}

