/*
 * Decompiled with CFR 0.152.
 */
package prog.core.index;

import fork.lib.base.collection.Pair;
import fork.lib.bio.seq.parser.fasta.FastaEntry;
import fork.lib.bio.seq.parser.fasta.FastaReader;
import java.io.File;
import java.util.ArrayList;

public class FastaTitleParser {
    public static String SEP = " ";
    public static String SEP_IDNAME = "_";
    public static String SEP_LOCATION = ",";
    public static String SEP_LOWHIGH = "-";
    protected String head;
    protected String geneName;
    protected String trID;
    protected String chr;
    protected char std;
    protected ArrayList<Pair<Integer, Integer>> lhs = new ArrayList();
    private Pair<Integer, Integer> codons;

    public FastaTitleParser(String head) {
        this.head = head;
        this.init();
    }

    protected void init() {
        String[] ss = this.head.split(SEP);
        String[] gchs = ss[0].split(SEP_IDNAME);
        this.trID = gchs[0];
        this.geneName = gchs[1];
        this.chr = ss[1];
        this.std = ss[2].charAt(0);
        String[] pss = ss[3].split(",");
        this.codons = new Pair((Object)Integer.parseInt(pss[0]), (Object)Integer.parseInt(pss[1]));
        String[] locs = ss[4].split(SEP_LOCATION);
        for (int i = 0; i < locs.length; ++i) {
            String[] locss = locs[i].split(SEP_LOWHIGH);
            this.lhs.add((Pair<Integer, Integer>)new Pair((Object)Integer.parseInt(locss[0]), (Object)Integer.parseInt(locss[1])));
        }
    }

    public String transcriptID() {
        return this.trID;
    }

    public String geneName() {
        return this.geneName;
    }

    public String chr() {
        return this.chr;
    }

    public char strand() {
        return this.std;
    }

    public boolean isForwardStrand() {
        return this.std == '+';
    }

    public ArrayList<Pair<Integer, Integer>> lowHighs() {
        return this.lhs;
    }

    public Pair<Integer, Integer> codons() {
        return this.codons;
    }

    public static void main(String[] args) throws Exception {
        File f = new File("C:\\muxingu\\progs\\java\\SangerSoftware2\\file/gene.fa");
        FastaEntry en = new FastaReader(f).nextEntry();
        FastaTitleParser pp = new FastaTitleParser(en.title());
    }
}

