/*
 * Decompiled with CFR 0.152.
 */
package prog.core.index;

import fork.lib.base.collection.Pair;
import fork.lib.math.applied.stat.FrequencyCount;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import prog.core.aln.ele.Gene;
import prog.core.aln.ele.Isoform;
import prog.core.aln.ele.IsoformStrand;

public class Index
implements Serializable {
    public final Date date;
    public final String version;
    private int kmer;
    private HashMap<String, Gene> idgene = new HashMap();
    private HashMap<String, IsoformStrand> idiso = new HashMap();
    private HashMap<String, HashMap<String, ArrayList<Integer>>> smap = new HashMap();
    public HashSet<String> targetGenes = new HashSet();
    public HashSet<String> itdGenes = new HashSet();
    public HashMap<String, HashSet<String>> transPairs = new HashMap();
    public HashMap<HashSet<String>, Pair<String, String>> correctPairs = new HashMap();
    public HashSet<Pair<String, String>> allPairPermutations = new HashSet();

    public void addTargetGenes(String ... gs) {
        this.targetGenes.addAll(Arrays.asList(gs));
    }

    public void setTargetGenes(String ... gs) {
        this.targetGenes = new HashSet();
        this.targetGenes.addAll(Arrays.asList(gs));
    }

    public void addItdGenes(String ... gs) {
        this.itdGenes.addAll(Arrays.asList(gs));
    }

    public void setItdGenes(String ... gs) {
        this.itdGenes = new HashSet();
        this.itdGenes.addAll(Arrays.asList(gs));
    }

    public Index(int kmer) {
        this.kmer = kmer;
        this.version = "1.2a";
        this.date = new Date(System.currentTimeMillis());
    }

    public void initPairs() {
        for (String a : this.transPairs.keySet()) {
            for (String b : this.transPairs.get(a)) {
                this.allPairPermutations.add((Pair<String, String>)new Pair((Object)a, (Object)b));
            }
        }
    }

    public void addSeed(String seed, IsoformStrand ist, Integer pos) {
        String id = ist.uniqueID();
        if (!this.idiso.containsKey(id)) {
            this.idiso.put(id, ist);
        }
        if (!this.smap.containsKey(seed)) {
            this.smap.put(seed, new HashMap());
        }
        if (!this.smap.get(seed).containsKey(id)) {
            this.smap.get(seed).put(id, new ArrayList());
        }
        this.smap.get(seed).get(id).add(pos);
    }

    public void addIsoformStrand(IsoformStrand ist) {
        String s = ist.sequence();
        for (int i = 0; i < s.length() - this.kmer; ++i) {
            String seed = s.substring(i, i + this.kmer);
            if (!Index.checkSeed(seed)) continue;
            this.addSeed(seed, ist, i);
        }
    }

    private static boolean checkSeed(String seed) {
        FrequencyCount fc = new FrequencyCount();
        for (int j = 0; j < seed.length(); ++j) {
            fc.add((Object)Character.valueOf(seed.charAt(j)));
        }
        double maxf = (double)fc.getCount(fc.mostFrequentKey()) / (double)seed.length();
        if (maxf > 0.8) {
            return false;
        }
        for (int i = 2; i <= 3; ++i) {
            ArrayList sets = new ArrayList();
            for (int j = 0; j < i; ++j) {
                sets.add(new HashSet());
            }
            int ind = 0;
            for (int j = 0; j < seed.length(); ++j) {
                ((HashSet)sets.get(ind)).add(Character.valueOf(seed.charAt(j)));
                if (++ind < sets.size()) continue;
                ind = 0;
            }
            boolean ifallone = true;
            for (int j = 0; j < sets.size(); ++j) {
                if (((HashSet)sets.get(j)).size() <= 1) continue;
                ifallone = false;
                break;
            }
            if (!ifallone) continue;
            return false;
        }
        return true;
    }

    public void addGene(Gene gene) {
        if (!this.idgene.containsKey(gene.ID())) {
            this.idgene.put(gene.ID(), gene);
        }
        for (Isoform iso : gene.isoforms()) {
            this.addIsoformStrand(iso.strandSense());
            this.addIsoformStrand(iso.strandAntisense());
        }
    }

    public int kmer() {
        return this.kmer;
    }

    public Gene getGene(String id) {
        return this.idgene.get(id);
    }

    public IsoformStrand getIsoformStrand(String id) {
        return this.idiso.get(id);
    }

    public HashMap<String, IsoformStrand> idToIsoformStrand() {
        return this.idiso;
    }

    public HashMap<String, HashMap<String, ArrayList<Integer>>> hashMap() {
        return this.smap;
    }

    public HashMap<String, Gene> idToGene() {
        return this.idgene;
    }

    public Pair<String, String> getCorrectPair(String a, String b) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(a, b));
        return this.correctPairs.get(set);
    }

    public void addTranslocationPair(String ga, String gb) {
        this.addTranslocationPairOrder(ga, gb, true);
        this.addTranslocationPairOrder(gb, ga, false);
    }

    private void addTranslocationPairOrder(String ga, String gb, boolean ifcorrect) {
        if (!this.transPairs.containsKey(ga)) {
            this.transPairs.put(ga, new HashSet());
        }
        this.transPairs.get(ga).add(gb);
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(ga, gb));
        if (ifcorrect) {
            this.correctPairs.put(set, (Pair<String, String>)new Pair((Object)ga, (Object)gb));
        } else {
            this.correctPairs.put(set, (Pair<String, String>)new Pair((Object)gb, (Object)ga));
        }
    }
}

