/*
 * Decompiled with CFR 0.152.
 */
package prog.core.index;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import prog.core.Statics;
import prog.core.index.Index;
import prog.core.index.IndexBuilderFasta;

public abstract class IndexBuilder {
    public Index index;

    public void write(String path) throws Exception {
        Output out = new Output((OutputStream)new GZIPOutputStream(new FileOutputStream(path)));
        Statics.kryo.writeClassAndObject(out, (Object)this.index);
        out.close();
    }

    public static Index read(String path) throws Exception {
        Input in = new Input((InputStream)new GZIPInputStream(new FileInputStream(path)));
        Index ret = (Index)Statics.kryo.readClassAndObject(in);
        in.close();
        return ret;
    }

    public abstract void build() throws Exception;

    public static void main(String[] args) throws Exception {
        IndexBuilderFasta.main(args);
    }
}

