/*
 * Decompiled with CFR 0.152.
 */
package prog.core.index;

import fork.lib.bio.seq.parser.fasta.FastaEntry;
import fork.lib.bio.seq.parser.fasta.FastaReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import prog.core.aln.ele.Gene;
import prog.core.aln.ele.TranscriptFragmentSet;
import prog.core.index.FastaTitleParser;
import prog.core.index.Index;
import prog.core.index.IndexBuilder;

public class IndexBuilderFasta
extends IndexBuilder {
    public int kmer = 10;
    private HashMap<String, Gene> idgs = new HashMap();

    public IndexBuilderFasta(Collection<FastaEntry> ens) throws Exception {
        for (FastaEntry en : ens) {
            try {
                this.addEntry(en);
            }
            catch (Exception e) {
                System.err.println("Not added: " + en.title());
            }
        }
    }

    @Override
    public void build() throws Exception {
        this.index = new Index(this.kmer);
        for (String gn : this.idgs.keySet()) {
            this.index.addGene(this.idgs.get(gn));
        }
    }

    protected void addEntry(FastaEntry en) throws Exception {
        FastaTitleParser ps = new FastaTitleParser(en.title());
        String geneName = ps.geneName;
        if (!this.idgs.containsKey(geneName)) {
            this.idgs.put(geneName, new Gene(geneName, ps.chr(), ps.strand()));
        }
        this.idgs.get(geneName).addTranscript(new TranscriptFragmentSet(ps.transcriptID(), ps.lowHighs(), ps.codons(), en.sequence()));
    }

    private void notin(String t) {
        System.err.println("Warning: target gene not in index: " + t + " - not added");
    }

    public void addTargetGenes(String ... tars) {
        for (String t : tars) {
            String gn = t.toUpperCase();
            if (this.index.idToGene().containsKey(gn)) {
                this.index.addTargetGenes(gn);
                System.out.println("Success: added target " + gn);
                continue;
            }
            this.notin(t);
        }
    }

    public void addTargetGenesAll() {
        for (String t : this.index.idToGene().keySet()) {
            this.addTargetGenes(t);
        }
    }

    public void addItdGenes(String ... tars) {
        for (String t : tars) {
            String gn = t.toUpperCase();
            if (this.index.idToGene().containsKey(gn)) {
                this.index.addItdGenes(gn);
                System.out.println("Success: added ITD " + gn);
                continue;
            }
            this.notin(t);
        }
    }

    public void addFusionPairs(String ... ps) {
        for (String p : ps) {
            String tb;
            String[] ss = p.split("-");
            if (ss.length != 2) {
                System.err.println("Error: wrong format in fusion: " + p + " - skipped");
                continue;
            }
            String ta = ss[0].toUpperCase();
            if (ta.equals(tb = ss[1].toUpperCase())) {
                System.err.println("Fusion partners identical: " + ta);
                continue;
            }
            boolean ina = this.index.idToGene().containsKey(ta);
            boolean inb = this.index.idToGene().containsKey(tb);
            if (!ina) {
                this.notin(ta);
            }
            if (!inb) {
                this.notin(tb);
            }
            if (!ina || !inb) continue;
            this.index.addTranslocationPair(ta, tb);
            System.out.println("Success: added fusion " + ta + "-" + tb);
        }
        this.index.initPairs();
    }

    public static void main(String[] args) throws Exception {
        FastaEntry en;
        File dir = new File("file");
        File fa = new File(dir + "/gene.fa");
        String outf = "index_AML-33genes_.ind";
        ArrayList<FastaEntry> ens = new ArrayList<FastaEntry>();
        FastaReader fr = new FastaReader(fa);
        while ((en = fr.nextEntry()) != null) {
            ens.add(en);
        }
        IndexBuilderFasta in = new IndexBuilderFasta(ens);
        in.build();
        in.addTargetGenes("NPM1", "DNMT3A", "TET2", "FLT3", "IDH2", "IDH1", "TP53", "CEBPA", "RUNX1", "SRSF2", "SF3B1", "U2AF1", "WT1", "ASXL1", "BCOR");
        in.addItdGenes("FLT3", "KMT2A");
        in.addFusionPairs("PML-RARA", "CBFB-MYH11", "RUNX1-RUNX1T1", "BCR-ABL1", "NUP98-NSD1", "KMT2A-AFDN", "KMT2A-MLLT3", "KMT2A-ELL", "KMT2A-MLLT10", "KMT2A-AFF1", "KMT2A-MLLT1", "KMT2A-EPS15", "KMT2A-MLLT11");
        in.write(outf);
    }
}

