/*
 * Decompiled with CFR 0.152.
 */
package prog.gui;

import fork.lib.base.file.FileOp;
import fork.lib.gui.soft.gen.comp.FMainFrame;
import fork.lib.gui.soft.gen.comp.Positioner;
import fork.lib.gui.soft.gen.comp.pan.PanelHelp;
import fork.lib.gui.soft.gen.util.FAnalysis;
import fork.lib.gui.soft.gen.util.init.FInitChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import prog.Sys;
import prog.core.Param;
import prog.core.ProgramMain;
import prog.gui.anal.Anal;
import prog.gui.anal.Main;
import prog.gui.comp.PanelNew;
import prog.gui.comp.PanelRunning;
import prog.gui.util.FWorker;
import prog.gui.util.TaWriter;

public class MainGui
extends FMainFrame {
    private Positioner pner;
    private Main main;

    public MainGui(Positioner pner) {
        this.pner = pner;
        this.main = new Main(this);
        if (Sys.pref.ifFirst) {
            pner.setWindowSizeRelativeToScreen((Component)((Object)this), 0.8, 0.8);
            this.initDividerLocations(0.2, 0.4);
            pner.positionAtScreenCentre((Component)((Object)this));
        } else {
            this.setSize(Sys.pref.dimension());
            this.mainPan.setDividerLocation(Sys.pref.divx);
            this.mainPan.spLeft.setDividerLocation(Sys.pref.divy);
            this.setLocation(Sys.pref.locx, Sys.pref.locy);
        }
        this.setTitle("RNAmut Version 1.2a");
        this.setIconImage(new ImageIcon(Sys.IMG_LOGO_16).getImage());
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MainGui.this.quit();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        Thread th = new Thread(){

            @Override
            public void run() {
                while (true) {
                    int tot = (int)(Runtime.getRuntime().totalMemory() / 1000000L);
                    int free = (int)(Runtime.getRuntime().freeMemory() / 1000000L);
                    MainGui.this.statusBar.setLabel("Free/total memory: " + free + "/" + tot + " MB");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        th.start();
        this.setVisible(true);
    }

    protected JComponent defaultRight() {
        JPanel p = new JPanel();
        p.add(new JLabel(""));
        return p;
    }

    protected JComponent defaultTopLeft() {
        JPanel p = new JPanel();
        p.add(new JLabel(""));
        return p;
    }

    protected JComponent defaultBtmLeft() {
        JPanel p = new JPanel();
        p.add(new JLabel(""));
        return p;
    }

    protected JMenuBar initJMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        final JMenuItem newAnal = new JMenuItem("New Analysis");
        JMenuItem openProj = new JMenuItem("Open...");
        final JMenuItem save = new JMenuItem("Save");
        final JMenuItem saveAll = new JMenuItem("Save All");
        final JMenuItem quit = new JMenuItem("Quit");
        newAnal.setIcon(new ImageIcon(Sys.IMG_NEW_16));
        newAnal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(newAnal)) {
                    MainGui.this.newAnal();
                }
            }
        });
        file.add(newAnal);
        file.addSeparator();
        save.setIcon(new ImageIcon(Sys.IMG_SAVE_16));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(save)) {
                    MainGui.this.saveAnal();
                }
            }
        });
        file.add(save);
        saveAll.setIcon(new ImageIcon(Sys.IMG_SAVE_ALL_16));
        saveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(saveAll)) {
                    MainGui.this.saveAll();
                }
            }
        });
        file.add(saveAll);
        file.addSeparator();
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(quit)) {
                    MainGui.this.quit();
                }
            }
        });
        file.add(quit);
        mb.add(file);
        JMenu helpM = new JMenu("Help");
        final JMenuItem help = new JMenuItem("Help");
        final JMenuItem about = new JMenuItem("About");
        help.setIcon(new ImageIcon(Sys.IMG_HELP_16));
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(help)) {
                    MainGui.this.help();
                }
            }
        });
        helpM.add(help);
        helpM.addSeparator();
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(about)) {
                    MainGui.this.about();
                }
            }
        });
        helpM.add(about);
        mb.add(helpM);
        return mb;
    }

    protected JToolBar initJToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        tb.setRollover(true);
        tb.addSeparator();
        tb.addSeparator();
        JButton newAnal = new JButton();
        newAnal.setIcon(new ImageIcon(Sys.IMG_NEW_32));
        newAnal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.newAnal();
            }
        });
        newAnal.setToolTipText("New Analysis");
        tb.add(newAnal);
        tb.addSeparator();
        JButton save = new JButton();
        save.setIcon(new ImageIcon(Sys.IMG_SAVE_32));
        save.setToolTipText("Save Analysis");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.saveAnal();
            }
        });
        tb.add(save);
        JButton saveAll = new JButton();
        saveAll.setIcon(new ImageIcon(Sys.IMG_SAVE_ALL_32));
        saveAll.setToolTipText("Save Output");
        saveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.saveAll();
            }
        });
        tb.add(saveAll);
        tb.addSeparator();
        JButton help = new JButton();
        help.setIcon(new ImageIcon(Sys.IMG_HELP_32));
        help.setToolTipText("Help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.help();
            }
        });
        tb.add(help);
        return tb;
    }

    public void newAnal() {
        this.setCursor(new Cursor(3));
        JDialog d = new JDialog((Frame)((Object)this), "New Analysis", true);
        PanelNew pan = new PanelNew(d);
        d.setContentPane(pan);
        d.setSize(new Dimension(500, 600));
        this.pner.positionAtCentreWithFactor((Component)d, (Component)((Object)this), 0.3, 0.2);
        d.setIconImage(new ImageIcon(Sys.IMG_LOGO_16).getImage());
        this.setCursor(new Cursor(0));
        d.setVisible(true);
        if (pan.ifStart()) {
            d.dispose();
            String analpath = Sys.DIR_TEMP + "/" + pan.analName();
            new File(analpath).mkdirs();
            final JDialog dr = new JDialog((Window)((Object)this), "Running", Dialog.ModalityType.APPLICATION_MODAL);
            PanelRunning prun = new PanelRunning(dr);
            dr.setContentPane(prun);
            dr.setSize(650, 350);
            this.pner.positionAtCentreWithFactor((Component)dr, (Component)((Object)this), 0.3, 0.2);
            final ProgramMain prog = pan.ifPE() ? new ProgramMain(null, analpath, new String[]{pan.file_1().getAbsolutePath(), pan.file_2().getAbsolutePath()}, analpath, pan.analName(), pan.index(), pan.pathoFilter(), new Param()) : new ProgramMain(null, analpath, new String[]{pan.file_1().getAbsolutePath()}, analpath, pan.analName(), pan.index(), pan.pathoFilter(), new Param());
            FWorker worker = new FWorker(dr, (JFrame)((Object)this), new TaWriter(prun.textArea())){

                @Override
                public Void doInBackground() {
                    try {
                        prog.setWriter(this.wr);
                        prog.start();
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.ifsucceed = true;
                        dr.dispose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                    return null;
                }

                @Override
                protected void done() {
                }
            };
            prun.setWorker(worker);
            worker.execute2();
            if (worker.ifsucceed) {
                this.main.addAnal(pan.analName(), analpath, prog.pathPool(), prog.pathAln(), prog.pathCorr(), prog.pathOnco(), pan.index());
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Programme stopped before completion!", "Error", 0);
            }
        }
    }

    public void openAnal() {
    }

    public void saveAnal() {
        FAnalysis ch;
        this.setCursor(new Cursor(3));
        for (ch = this.main.getCurrentChild(); ch != null && !(ch instanceof Anal) && ch.getParent() != null; ch = ch.getParent()) {
        }
        this.setCursor(new Cursor(0));
        if (ch == null) {
            return;
        }
        if (!(ch instanceof Anal)) {
            return;
        }
        File f = null;
        boolean correct = false;
        while (true) {
            JFileChooser jfc = new JFileChooser();
            jfc.setDialogType(1);
            jfc.setFileSelectionMode(1);
            jfc.setCurrentDirectory(new File(Sys.pref.saveDirectory()));
            this.setCursor(new Cursor(0));
            int returnVal = jfc.showSaveDialog((Component)((Object)this));
            if (returnVal != 0) break;
            File sf = jfc.getSelectedFile();
            Sys.pref.setSaveDirectory(sf.getAbsolutePath());
            if (MainGui.notintemp(sf)) {
                correct = true;
                f = sf;
                break;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot save in temp folder. Temp will be erased after program closes.\nPlease choose a different folder.", "Error", 0);
        }
        if (correct) {
            try {
                ((Anal)ch).save(f);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Cannot save to:\n" + f.getAbsolutePath(), "Error", 0);
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "Successfully saved to:\n    " + f.getAbsolutePath());
        }
    }

    private static boolean notintemp(File f) {
        String tn;
        String fn = f.getAbsolutePath();
        return fn.indexOf(tn = new File(Sys.DIR_TEMP).getAbsolutePath()) != 0;
    }

    public void saveAll() {
        if (this.main.children().isEmpty()) {
            return;
        }
        File f = null;
        boolean correct = false;
        while (true) {
            this.setCursor(new Cursor(3));
            JFileChooser jfc = new JFileChooser();
            jfc.setDialogType(1);
            jfc.setFileSelectionMode(1);
            jfc.setCurrentDirectory(new File(Sys.pref.saveAllDirectory()));
            this.setCursor(new Cursor(0));
            int returnVal = jfc.showSaveDialog((Component)((Object)this));
            if (returnVal != 0) break;
            File sf = jfc.getSelectedFile();
            Sys.pref.setSaveAllDirectory(sf.getAbsolutePath());
            if (MainGui.notintemp(sf)) {
                correct = true;
                f = sf;
                break;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot save in temp folder. Temp will be erased after program closes.\nPlease choose a different folder.", "Error", 0);
        }
        if (correct) {
            this.setCursor(new Cursor(3));
            Sys.pref.setSaveAllDirectory(f.getAbsolutePath());
            for (FAnalysis fa : this.main.children()) {
                Anal an = (Anal)fa;
                File od = new File(f + "/" + an.getTitle());
                try {
                    od.mkdirs();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot create directory:\n" + od.getAbsolutePath(), "Error", 0);
                    continue;
                }
                try {
                    an.save(od);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot save to:\n" + od.getAbsolutePath(), "Error", 0);
                }
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "All results saved to:\n    " + f.getAbsolutePath());
            this.setCursor(new Cursor(0));
        }
    }

    public void help() {
        PanelHelp h = new PanelHelp(this.main.getCurrentChild().helpMsg());
        final JDialog d = new JDialog((Frame)((Object)this));
        d.setModal(false);
        d.setUndecorated(true);
        d.setContentPane((Container)h);
        d.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                d.dispose();
            }
        });
        d.setSize(300, 400);
        this.pner.positionAtCentreWithFactor((Component)d, (Component)((Object)this), 0.4, 0.2);
        d.setVisible(true);
    }

    public void about() {
    }

    public void quit() {
        String uns = "";
        for (FAnalysis c : this.main.children()) {
            Anal an = (Anal)c;
            if (an.ifsave) continue;
            uns = uns + "    " + an.getTitle();
        }
        if (!uns.equals("")) {
            int r = JOptionPane.showConfirmDialog((Component)((Object)this), "Following analyses have not been saved yet:\n" + uns + "\nUnsaved analyses will be lost. Quit anyway?", "Quit", 0, 2);
            if (r == 0) {
                this.close();
            }
        } else {
            this.close();
        }
    }

    private void close() {
        Sys.pref.save();
        FileOp.unlinkAll((File)new File(Sys.DIR_TEMP), (boolean)false);
        this.dispose();
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Positioner pner = new Positioner();
        FInitChecker c = new FInitChecker();
        c.addEssentialPaths(new String[]{Sys.DIR_LIB, Sys.LIB_BASE, Sys.LIB_MATH, Sys.LIB_GUI, Sys.LIB_SEQ, Sys.LIB_KYRO, Sys.LIB_MINOLOG, Sys.LIB_OBJ, Sys.LIB_REFLECT, Sys.DIR_IMG, Sys.IMG_NEW_32, Sys.IMG_OPEN_32, Sys.IMG_SAVE_32, Sys.IMG_SAVE2_32, Sys.IMG_SAVE_ALL_32, Sys.IMG_HELP_32, Sys.IMG_LOGO_16, Sys.IMG_NEW_16, Sys.IMG_OPEN_16, Sys.IMG_SAVE_16, Sys.IMG_SAVE2_16, Sys.IMG_SAVE_ALL_16, Sys.IMG_HELP_16, Sys.IMG_FOLDER_16, Sys.IMG_TICK_16, Sys.IMG_CROSS_16});
        c.addRecommendedPaths(new String[]{Sys.DIR_DEMO, Sys.FILE_DEMO1, Sys.FILE_DEMO2, Sys.FILE_INDEX, Sys.FILE_ONCO});
        c.setEssentialDiskSpace(200);
        c.setRecommendedDiskSpace(500);
        c.setEssentialMemory(400);
        c.setRecommendedMemory(1024);
        c.check();
        c.showErrorMessageAndDie();
        if (c.showWarningMessageAndConfirm()) {
            MainGui mainGui = new MainGui(pner);
        } else {
            System.exit(1);
        }
    }
}

