/*
 * Decompiled with CFR 0.152.
 */
package prog.gui;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import prog.Sys;
import prog.core.Statics;
import prog.gui.MainGui;

public class Preference
implements Serializable {
    public boolean ifFirst = true;
    public boolean ifFirstNewAnal = true;
    private int width;
    private int height;
    public int divx;
    public int divy;
    public int locx;
    public int locy;
    private String fastqdir;
    private String indexdir;
    private String pathodir;
    private String savedir;
    private String savealldir;

    public Dimension dimension() {
        int w = this.width < 500 ? 800 : this.width;
        int h = this.height < 500 ? 600 : this.height;
        return new Dimension(w, h);
    }

    private String dir(String dir) {
        if (dir != null && new File(dir).isDirectory()) {
            return dir;
        }
        return Sys.DIR;
    }

    public String fastqDirectory() {
        return this.dir(this.fastqdir);
    }

    public String indexDirectory() {
        return this.dir(this.indexdir);
    }

    public String pathoDirectory() {
        return this.dir(this.pathodir);
    }

    public String saveDirectory() {
        return this.dir(this.savedir);
    }

    public String saveAllDirectory() {
        return this.dir(this.savealldir);
    }

    public void setFastqDirectory(String d) {
        this.fastqdir = d;
    }

    public void setIndexDirectory(String d) {
        this.indexdir = d;
    }

    public void setPathoDirectory(String d) {
        this.pathodir = d;
    }

    public void setSaveDirectory(String d) {
        this.savedir = d;
    }

    public void setSaveAllDirectory(String d) {
        this.savealldir = d;
    }

    public void save() {
        try {
            this.write(Sys.prefPath);
            this.ifFirst = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateMain(MainGui mf) {
        this.width = mf.getWidth();
        this.height = mf.getHeight();
        this.divx = mf.mainPan.getDividerLocation();
        this.divy = mf.mainPan.spLeft.getDividerLocation();
        this.locx = mf.getLocation().x;
        this.locy = mf.getLocation().y;
    }

    public void write(String path) throws Exception {
        Output out = new Output((OutputStream)new GZIPOutputStream(new FileOutputStream(path)));
        Statics.kryo.writeClassAndObject(out, (Object)this);
        out.close();
    }

    public static Preference read(String path) throws Exception {
        Input in = new Input((InputStream)new GZIPInputStream(new FileInputStream(path)));
        Preference ret = (Preference)Statics.kryo.readClassAndObject(in);
        in.close();
        return ret;
    }
}

