/*
 * Decompiled with CFR 0.152.
 */
package prog.gui.anal;

import fork.lib.gui.soft.gen.util.FAnalysis;
import java.awt.Cursor;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import prog.Sys;
import prog.core.aln.mut.MutationResult;
import prog.core.aln.read.ReadPool;
import prog.core.aln.res.AlignmentResult;
import prog.core.index.Index;
import prog.gui.anal.AnalSub;
import prog.gui.anal.AnalSubIndex;
import prog.gui.anal.FTreeNode;
import prog.gui.anal.Main;

public class Anal
extends FAnalysis {
    private String dir;
    private String poolpath;
    private String alnpath;
    private String corrpath;
    public Index index;
    public ReadPool pool;
    public AlignmentResult alnres;
    public MutationResult mutonc;
    public JList list;
    public int listind = 0;
    public FTreeNode node;
    public boolean ifsave = false;

    public Anal(Main main, String tag, String dir, String poolpath, String alnpath, String corrpath, String oncopath, Index index) {
        super((FAnalysis)main);
        main.gui().setCursor(new Cursor(3));
        this.tit = tag;
        this.dir = dir;
        this.poolpath = poolpath;
        this.alnpath = alnpath;
        this.corrpath = corrpath;
        this.index = index;
        try {
            this.pool = ReadPool.read(poolpath);
            this.alnres = AlignmentResult.read(alnpath, index, this.pool);
            this.mutonc = MutationResult.read(this.corrpath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultListModel<String> mod = new DefaultListModel<String>();
        mod.addElement("Gene Index");
        new AnalSubIndex(this, index);
        mod.addElement("Result: Mutations");
        new AnalSub(this, "Mutations", this.mutonc.allMutations(), index);
        this.list = new JList(mod);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Anal.this.listind = ((JList)e.getSource()).getSelectedIndex();
                ((FAnalysis)Anal.this.children.get(Anal.this.listind)).reRenderChain();
            }
        });
        this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
        this.reloadComponents();
        this.reRenderChain();
        main.gui().setCursor(new Cursor(0));
    }

    public void reloadComponents() {
        this.node = new FTreeNode(this, this.tit);
    }

    protected void destroy() {
        this.node = null;
        this.pool = null;
        this.alnres = null;
    }

    public void render() {
        JTabbedPane tab = new JTabbedPane();
        tab.addTab("Genes", new ImageIcon(Sys.IMG_FOLDER_16), this.list);
        try {
            this.list.setSelectedIndex(this.listind);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Main)this.getTopParent()).gui().mainPan.setJSPBtmLeft((JComponent)tab);
    }

    public void save(File dir) throws Exception {
        MutationResult.writeToTxtFile(this.mutonc, this.index, this.pool, dir + "/" + this.tit + "_mutations.txt", false);
        this.ifsave = true;
    }
}

